/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.LabelImportant: ImageVector
    get() {
        if (_labelImportant != null) {
            return _labelImportant!!
        }
        _labelImportant = materialIcon(name = "TwoTone.LabelImportant") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(15.0f, 7.0f)
                horizontalLineTo(7.89f)
                lineToRelative(3.57f, 5.0f)
                lineToRelative(-3.57f, 5.0f)
                horizontalLineTo(15.0f)
                lineToRelative(3.55f, -5.0f)
                close()
            }
            materialPath {
                moveTo(16.63f, 5.84f)
                curveTo(16.27f, 5.33f, 15.67f, 5.0f, 15.0f, 5.0f)
                horizontalLineTo(4.0f)
                lineToRelative(5.0f, 7.0f)
                lineToRelative(-5.0f, 6.99f)
                horizontalLineToRelative(11.0f)
                curveToRelative(0.67f, 0.0f, 1.27f, -0.32f, 1.63f, -0.83f)
                lineTo(21.0f, 12.0f)
                lineToRelative(-4.37f, -6.16f)
                close()
                moveTo(15.0f, 17.0f)
                horizontalLineTo(7.89f)
                lineToRelative(3.57f, -5.0f)
                lineToRelative(-3.57f, -5.0f)
                horizontalLineTo(15.0f)
                lineToRelative(3.55f, 5.0f)
                lineTo(15.0f, 17.0f)
                close()
            }
        }
        return _labelImportant!!
    }

private var _labelImportant: ImageVector? = null
