/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.PanoramaVerticalSelect: ImageVector
    get() {
        if (_panoramaVerticalSelect != null) {
            return _panoramaVerticalSelect!!
        }
        _panoramaVerticalSelect = materialIcon(name = "TwoTone.PanoramaVerticalSelect") {
            materialPath {
                moveTo(18.5f, 12.0f)
                curveToRelative(0.0f, -3.89f, 0.84f, -6.95f, 1.43f, -8.69f)
                curveTo(20.15f, 2.67f, 19.67f, 2.0f, 18.98f, 2.0f)
                lineTo(5.0f, 2.0f)
                curveTo(4.32f, 2.0f, 3.84f, 2.66f, 4.05f, 3.31f)
                curveTo(4.74f, 5.36f, 5.5f, 8.1f, 5.5f, 12.0f)
                curveToRelative(0.0f, 3.87f, -0.76f, 6.66f, -1.45f, 8.69f)
                curveTo(3.84f, 21.34f, 4.32f, 22.0f, 5.0f, 22.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(0.68f, 0.0f, 1.17f, -0.66f, 0.95f, -1.31f)
                curveTo(19.27f, 18.66f, 18.5f, 15.86f, 18.5f, 12.0f)
                close()
            }
        }
        return _panoramaVerticalSelect!!
    }

private var _panoramaVerticalSelect: ImageVector? = null
