/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SatelliteAlt: ImageVector
    get() {
        if (_satelliteAlt != null) {
            return _satelliteAlt!!
        }
        _satelliteAlt = materialIcon(name = "TwoTone.SatelliteAlt") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.6f, 19.32f)
                lineToRelative(-1.06f, 1.06f)
                lineTo(2.0f, 16.85f)
                lineToRelative(1.06f, -1.06f)
                lineTo(6.6f, 19.32f)
                close()
                moveTo(8.72f, 17.2f)
                lineToRelative(-1.06f, 1.06f)
                lineToRelative(-3.54f, -3.54f)
                lineToRelative(1.06f, -1.06f)
                lineTo(8.72f, 17.2f)
                close()
                moveTo(13.67f, 12.25f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(-3.54f, -3.54f)
                lineToRelative(1.41f, -1.41f)
                lineTo(13.67f, 12.25f)
                close()
                moveTo(18.26f, 7.66f)
                lineTo(17.2f, 8.72f)
                lineToRelative(-3.54f, -3.54f)
                lineToRelative(1.06f, -1.06f)
                lineTo(18.26f, 7.66f)
                close()
                moveTo(20.38f, 5.54f)
                lineTo(19.32f, 6.6f)
                lineToRelative(-3.54f, -3.54f)
                lineTo(16.85f, 2.0f)
                lineTo(20.38f, 5.54f)
                close()
            }
            materialPath {
                moveTo(15.44f, 0.59f)
                lineToRelative(-3.18f, 3.18f)
                curveToRelative(-0.78f, 0.78f, -0.78f, 2.05f, 0.0f, 2.83f)
                lineToRelative(1.24f, 1.24f)
                lineToRelative(-0.71f, 0.71f)
                lineTo(11.55f, 7.3f)
                curveToRelative(-0.78f, -0.78f, -2.05f, -0.78f, -2.83f, 0.0f)
                lineTo(7.3f, 8.72f)
                curveToRelative(-0.78f, 0.78f, -0.78f, 2.05f, 0.0f, 2.83f)
                lineToRelative(1.24f, 1.24f)
                lineToRelative(-0.71f, 0.71f)
                lineTo(6.6f, 12.25f)
                curveToRelative(-0.78f, -0.78f, -2.05f, -0.78f, -2.83f, 0.0f)
                lineToRelative(-3.18f, 3.18f)
                curveToRelative(-0.78f, 0.78f, -0.78f, 2.05f, 0.0f, 2.83f)
                lineToRelative(3.54f, 3.54f)
                curveToRelative(0.78f, 0.78f, 2.05f, 0.78f, 2.83f, 0.0f)
                lineToRelative(3.18f, -3.18f)
                curveToRelative(0.78f, -0.78f, 0.78f, -2.05f, 0.0f, -2.83f)
                lineToRelative(-1.24f, -1.24f)
                lineToRelative(0.71f, -0.71f)
                lineToRelative(1.24f, 1.24f)
                curveToRelative(0.78f, 0.78f, 2.05f, 0.78f, 2.83f, 0.0f)
                lineToRelative(1.41f, -1.41f)
                curveToRelative(0.78f, -0.78f, 0.78f, -2.05f, 0.0f, -2.83f)
                lineTo(13.84f, 9.6f)
                lineToRelative(0.71f, -0.71f)
                lineToRelative(1.24f, 1.24f)
                curveToRelative(0.78f, 0.78f, 2.05f, 0.78f, 2.83f, 0.0f)
                lineToRelative(3.18f, -3.18f)
                curveToRelative(0.78f, -0.78f, 0.78f, -2.05f, 0.0f, -2.83f)
                lineToRelative(-3.54f, -3.54f)
                curveTo(17.48f, -0.2f, 16.22f, -0.2f, 15.44f, 0.59f)
                close()
                moveTo(6.6f, 19.32f)
                lineToRelative(-1.06f, 1.06f)
                lineTo(2.0f, 16.85f)
                lineToRelative(1.06f, -1.06f)
                lineTo(6.6f, 19.32f)
                close()
                moveTo(8.72f, 17.2f)
                lineToRelative(-1.06f, 1.06f)
                lineToRelative(-3.54f, -3.54f)
                lineToRelative(1.06f, -1.06f)
                lineTo(8.72f, 17.2f)
                close()
                moveTo(13.67f, 12.25f)
                lineToRelative(-1.41f, 1.41f)
                lineToRelative(-3.54f, -3.54f)
                lineToRelative(1.41f, -1.41f)
                lineTo(13.67f, 12.25f)
                close()
                moveTo(18.26f, 7.66f)
                lineTo(17.2f, 8.72f)
                lineToRelative(-3.54f, -3.54f)
                lineToRelative(1.06f, -1.06f)
                lineTo(18.26f, 7.66f)
                close()
                moveTo(20.38f, 5.54f)
                lineTo(19.32f, 6.6f)
                lineToRelative(-3.54f, -3.54f)
                lineTo(16.85f, 2.0f)
                lineTo(20.38f, 5.54f)
                close()
                moveTo(21.0f, 14.0f)
                lineToRelative(2.0f, 0.0f)
                curveToRelative(0.0f, 4.97f, -4.03f, 9.0f, -9.0f, 9.0f)
                lineToRelative(0.0f, -2.0f)
                curveTo(17.87f, 21.0f, 21.0f, 17.87f, 21.0f, 14.0f)
                close()
                moveTo(17.0f, 14.0f)
                lineToRelative(2.0f, 0.0f)
                curveToRelative(0.0f, 2.76f, -2.24f, 5.0f, -5.0f, 5.0f)
                lineToRelative(0.0f, -2.0f)
                curveTo(15.66f, 17.0f, 17.0f, 15.66f, 17.0f, 14.0f)
                close()
            }
        }
        return _satelliteAlt!!
    }

private var _satelliteAlt: ImageVector? = null
