/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Hail: ImageVector
    get() {
        if (_hail != null) {
            return _hail!!
        }
        _hail = materialIcon(name = "Filled.Hail") {
            materialPath {
                moveTo(12.0f, 6.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                reflectiveCurveToRelative(0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                close()
                moveTo(17.0f, 2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(0.4f)
                curveToRelative(-0.1f, 2.2f, -0.8f, 3.9f, -2.3f, 5.1f)
                curveToRelative(-0.5f, 0.4f, -1.1f, 0.7f, -1.7f, 0.9f)
                lineTo(15.0f, 22.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(6.0f)
                lineTo(9.0f, 22.0f)
                lineTo(9.0f, 10.1f)
                curveToRelative(-0.3f, 0.1f, -0.5f, 0.2f, -0.6f, 0.3f)
                curveToRelative(-0.9f, 0.7f, -1.39f, 1.6f, -1.4f, 3.1f)
                verticalLineToRelative(0.5f)
                lineTo(5.0f, 14.0f)
                verticalLineToRelative(-0.5f)
                curveToRelative(0.0f, -2.0f, 0.71f, -3.59f, 2.11f, -4.79f)
                curveTo(8.21f, 7.81f, 10.0f, 7.0f, 12.0f, 7.0f)
                reflectiveCurveToRelative(2.68f, -0.46f, 3.48f, -1.06f)
                curveTo(16.48f, 5.14f, 17.0f, 4.0f, 17.0f, 2.5f)
                lineTo(17.0f, 2.0f)
                close()
                moveTo(4.0f, 16.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(6.0f)
                lineTo(4.0f, 22.0f)
                verticalLineToRelative(-6.0f)
                close()
            }
        }
        return _hail!!
    }

private var _hail: ImageVector? = null
