/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.LinearScale: ImageVector
    get() {
        if (_linearScale != null) {
            return _linearScale!!
        }
        _linearScale = materialIcon(name = "Filled.LinearScale") {
            materialPath {
                moveTo(19.5f, 9.5f)
                curveToRelative(-1.03f, 0.0f, -1.9f, 0.62f, -2.29f, 1.5f)
                horizontalLineToRelative(-2.92f)
                curveTo(13.9f, 10.12f, 13.03f, 9.5f, 12.0f, 9.5f)
                reflectiveCurveToRelative(-1.9f, 0.62f, -2.29f, 1.5f)
                horizontalLineTo(6.79f)
                curveTo(6.4f, 10.12f, 5.53f, 9.5f, 4.5f, 9.5f)
                curveTo(3.12f, 9.5f, 2.0f, 10.62f, 2.0f, 12.0f)
                reflectiveCurveToRelative(1.12f, 2.5f, 2.5f, 2.5f)
                curveToRelative(1.03f, 0.0f, 1.9f, -0.62f, 2.29f, -1.5f)
                horizontalLineToRelative(2.92f)
                curveToRelative(0.39f, 0.88f, 1.26f, 1.5f, 2.29f, 1.5f)
                reflectiveCurveToRelative(1.9f, -0.62f, 2.29f, -1.5f)
                horizontalLineToRelative(2.92f)
                curveToRelative(0.39f, 0.88f, 1.26f, 1.5f, 2.29f, 1.5f)
                curveToRelative(1.38f, 0.0f, 2.5f, -1.12f, 2.5f, -2.5f)
                reflectiveCurveTo(20.88f, 9.5f, 19.5f, 9.5f)
                close()
            }
        }
        return _linearScale!!
    }

private var _linearScale: ImageVector? = null
