/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.MoneyOffCsred: ImageVector
    get() {
        if (_moneyOffCsred != null) {
            return _moneyOffCsred!!
        }
        _moneyOffCsred = materialIcon(name = "Filled.MoneyOffCsred") {
            materialPath {
                moveTo(10.53f, 7.43f)
                curveToRelative(0.42f, -0.31f, 0.93f, -0.47f, 1.54f, -0.47f)
                reflectiveCurveToRelative(1.11f, 0.16f, 1.5f, 0.49f)
                curveToRelative(0.39f, 0.32f, 0.65f, 0.7f, 0.79f, 1.12f)
                lineToRelative(1.89f, -0.8f)
                curveToRelative(-0.24f, -0.71f, -0.71f, -1.35f, -1.4f, -1.92f)
                curveToRelative(-0.5f, -0.4f, -1.12f, -0.65f, -1.85f, -0.77f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.11f)
                curveToRelative(-0.41f, 0.08f, -0.79f, 0.21f, -1.14f, 0.39f)
                curveToRelative(-0.35f, 0.18f, -0.64f, 0.39f, -0.9f, 0.63f)
                lineToRelative(1.43f, 1.43f)
                curveTo(10.43f, 7.52f, 10.48f, 7.47f, 10.53f, 7.43f)
                close()
                moveTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineToRelative(12.35f, 12.35f)
                curveTo(13.31f, 16.85f, 12.79f, 17.0f, 12.19f, 17.0f)
                curveToRelative(-0.71f, 0.0f, -1.32f, -0.23f, -1.83f, -0.7f)
                curveToRelative(-0.5f, -0.47f, -0.86f, -1.07f, -1.06f, -1.81f)
                lineToRelative(-1.98f, 0.8f)
                curveToRelative(0.34f, 1.17f, 0.95f, 2.08f, 1.83f, 2.73f)
                curveToRelative(0.57f, 0.42f, 1.19f, 0.68f, 1.85f, 0.83f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.08f)
                curveToRelative(0.44f, -0.07f, 0.87f, -0.17f, 1.29f, -0.35f)
                curveToRelative(0.34f, -0.14f, 0.64f, -0.32f, 0.92f, -0.53f)
                lineToRelative(4.57f, 4.57f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                close()
            }
        }
        return _moneyOffCsred!!
    }

private var _moneyOffCsred: ImageVector? = null
