/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.PestControl: ImageVector
    get() {
        if (_pestControl != null) {
            return _pestControl!!
        }
        _pestControl = materialIcon(name = "Filled.PestControl") {
            materialPath {
                moveTo(21.0f, 15.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-3.07f)
                curveToRelative(-0.05f, -0.39f, -0.12f, -0.77f, -0.22f, -1.14f)
                lineToRelative(2.58f, -1.49f)
                lineToRelative(-1.0f, -1.73f)
                lineTo(16.92f, 10.0f)
                curveToRelative(-0.28f, -0.48f, -0.62f, -0.91f, -0.99f, -1.29f)
                curveTo(15.97f, 8.48f, 16.0f, 8.25f, 16.0f, 8.0f)
                curveToRelative(0.0f, -0.8f, -0.24f, -1.55f, -0.65f, -2.18f)
                lineTo(17.0f, 4.17f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(-1.72f, 1.72f)
                curveToRelative(-1.68f, -0.89f, -3.1f, -0.33f, -3.73f, 0.0f)
                lineTo(8.41f, 2.76f)
                lineTo(7.0f, 4.17f)
                lineToRelative(1.65f, 1.65f)
                curveTo(8.24f, 6.45f, 8.0f, 7.2f, 8.0f, 8.0f)
                curveToRelative(0.0f, 0.25f, 0.03f, 0.48f, 0.07f, 0.72f)
                curveTo(7.7f, 9.1f, 7.36f, 9.53f, 7.08f, 10.0f)
                lineTo(4.71f, 8.63f)
                lineToRelative(-1.0f, 1.73f)
                lineToRelative(2.58f, 1.49f)
                curveToRelative(-0.1f, 0.37f, -0.17f, 0.75f, -0.22f, 1.14f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(3.07f)
                curveToRelative(0.05f, 0.39f, 0.12f, 0.77f, 0.22f, 1.14f)
                lineToRelative(-2.58f, 1.49f)
                lineToRelative(1.0f, 1.73f)
                lineTo(7.08f, 18.0f)
                curveToRelative(1.08f, 1.81f, 2.88f, 3.0f, 4.92f, 3.0f)
                reflectiveCurveToRelative(3.84f, -1.19f, 4.92f, -3.0f)
                lineToRelative(2.37f, 1.37f)
                lineToRelative(1.0f, -1.73f)
                lineToRelative(-2.58f, -1.49f)
                curveToRelative(0.1f, -0.37f, 0.17f, -0.75f, 0.22f, -1.14f)
                horizontalLineTo(21.0f)
                close()
                moveTo(13.0f, 17.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(17.0f)
                close()
            }
        }
        return _pestControl!!
    }

private var _pestControl: ImageVector? = null
