/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.ScheduleSend: ImageVector
    get() {
        if (_scheduleSend != null) {
            return _scheduleSend!!
        }
        _scheduleSend = materialIcon(name = "Filled.ScheduleSend") {
            materialPath {
                moveTo(16.5f, 12.5f)
                lineTo(15.0f, 12.5f)
                verticalLineToRelative(4.0f)
                lineToRelative(3.0f, 2.0f)
                lineToRelative(0.75f, -1.23f)
                lineToRelative(-2.25f, -1.52f)
                lineTo(16.5f, 12.5f)
                close()
                moveTo(16.0f, 9.0f)
                lineTo(2.0f, 3.0f)
                verticalLineToRelative(7.0f)
                lineToRelative(9.0f, 2.0f)
                lineToRelative(-9.0f, 2.0f)
                verticalLineToRelative(7.0f)
                lineToRelative(7.27f, -3.11f)
                curveTo(10.09f, 20.83f, 12.79f, 23.0f, 16.0f, 23.0f)
                curveToRelative(3.86f, 0.0f, 7.0f, -3.14f, 7.0f, -7.0f)
                reflectiveCurveToRelative(-3.14f, -7.0f, -7.0f, -7.0f)
                close()
                moveTo(16.0f, 21.0f)
                curveToRelative(-2.75f, 0.0f, -4.98f, -2.22f, -5.0f, -4.97f)
                verticalLineToRelative(-0.07f)
                curveToRelative(0.02f, -2.74f, 2.25f, -4.97f, 5.0f, -4.97f)
                curveToRelative(2.76f, 0.0f, 5.0f, 2.24f, 5.0f, 5.0f)
                reflectiveCurveTo(18.76f, 21.0f, 16.0f, 21.0f)
                close()
            }
        }
        return _scheduleSend!!
    }

private var _scheduleSend: ImageVector? = null
