/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Upcoming: ImageVector
    get() {
        if (_upcoming != null) {
            return _upcoming!!
        }
        _upcoming = materialIcon(name = "Filled.Upcoming") {
            materialPath {
                moveTo(21.16f, 7.26f)
                lineToRelative(-1.41f, -1.41f)
                lineTo(16.19f, 9.4f)
                lineToRelative(1.41f, 1.41f)
                curveTo(17.6f, 10.81f, 21.05f, 7.29f, 21.16f, 7.26f)
                close()
            }
            materialPath {
                moveTo(11.0f, 3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath {
                moveTo(6.4f, 10.81f)
                lineTo(7.81f, 9.4f)
                lineTo(4.26f, 5.84f)
                lineTo(2.84f, 7.26f)
                curveTo(2.95f, 7.29f, 6.4f, 10.81f, 6.4f, 10.81f)
                close()
            }
            materialPath {
                moveTo(20.0f, 12.0f)
                horizontalLineToRelative(-5.0f)
                curveToRelative(0.0f, 1.66f, -1.34f, 3.0f, -3.0f, 3.0f)
                reflectiveCurveToRelative(-3.0f, -1.34f, -3.0f, -3.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(5.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-5.0f)
                curveTo(22.0f, 12.9f, 21.1f, 12.0f, 20.0f, 12.0f)
                close()
            }
        }
        return _upcoming!!
    }

private var _upcoming: ImageVector? = null
