/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.ArrowBackIosNew: ImageVector
    get() {
        if (_arrowBackIosNew != null) {
            return _arrowBackIosNew!!
        }
        _arrowBackIosNew = materialIcon(name = "Outlined.ArrowBackIosNew") {
            materialPath {
                moveTo(17.77f, 3.77f)
                lineToRelative(-1.77f, -1.77f)
                lineToRelative(-10.0f, 10.0f)
                lineToRelative(10.0f, 10.0f)
                lineToRelative(1.77f, -1.77f)
                lineToRelative(-8.23f, -8.23f)
                close()
            }
        }
        return _arrowBackIosNew!!
    }

private var _arrowBackIosNew: ImageVector? = null
