/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Atm: ImageVector
    get() {
        if (_atm != null) {
            return _atm!!
        }
        _atm = materialIcon(name = "Outlined.Atm") {
            materialPath {
                moveTo(8.0f, 9.0f)
                verticalLineToRelative(1.5f)
                horizontalLineToRelative(2.25f)
                lineTo(10.25f, 15.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-4.5f)
                lineTo(14.0f, 10.5f)
                lineTo(14.0f, 9.0f)
                lineTo(8.0f, 9.0f)
                close()
                moveTo(6.0f, 9.0f)
                lineTo(3.0f, 9.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-1.5f)
                horizontalLineToRelative(2.0f)
                lineTo(5.5f, 15.0f)
                lineTo(7.0f, 15.0f)
                verticalLineToRelative(-5.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                close()
                moveTo(5.5f, 12.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.5f)
                horizontalLineToRelative(2.0f)
                lineTo(5.5f, 12.0f)
                close()
                moveTo(21.0f, 9.0f)
                horizontalLineToRelative(-4.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(5.0f)
                lineTo(17.0f, 15.0f)
                verticalLineToRelative(-4.5f)
                horizontalLineToRelative(1.0f)
                lineTo(18.0f, 14.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-3.51f)
                horizontalLineToRelative(1.0f)
                lineTo(20.5f, 15.0f)
                lineTo(22.0f, 15.0f)
                verticalLineToRelative(-5.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                close()
            }
        }
        return _atm!!
    }

private var _atm: ImageVector? = null
