/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Landslide: ImageVector
    get() {
        if (_landslide != null) {
            return _landslide!!
        }
        _landslide = materialIcon(name = "Outlined.Landslide") {
            materialPath {
                moveTo(11.0f, 12.0f)
                lineTo(8.0f, 8.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(20.0f)
                lineToRelative(-6.0f, -8.0f)
                lineTo(11.0f, 12.0f)
                close()
                moveTo(12.53f, 14.77f)
                lineTo(6.0f, 16.95f)
                lineToRelative(-2.0f, -0.67f)
                verticalLineToRelative(-1.89f)
                lineToRelative(2.0f, 0.67f)
                lineToRelative(3.95f, -1.32f)
                lineTo(12.53f, 14.77f)
                close()
                moveTo(7.0f, 10.0f)
                lineToRelative(1.57f, 2.09f)
                lineTo(6.0f, 12.95f)
                lineToRelative(-2.0f, -0.67f)
                verticalLineTo(10.0f)
                horizontalLineTo(7.0f)
                close()
                moveTo(4.0f, 20.0f)
                verticalLineToRelative(-1.61f)
                lineToRelative(2.0f, 0.67f)
                lineToRelative(9.03f, -3.01f)
                lineTo(18.0f, 20.0f)
                horizontalLineTo(4.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 6.0f)
                verticalLineTo(1.0f)
                lineToRelative(-5.0f, -1.0f)
                lineTo(9.0f, 2.0f)
                verticalLineToRelative(4.0f)
                lineToRelative(3.0f, 2.0f)
                lineTo(17.0f, 6.0f)
                close()
                moveTo(11.0f, 3.07f)
                lineToRelative(1.42f, -0.95f)
                lineTo(15.0f, 2.64f)
                verticalLineToRelative(2.01f)
                lineToRelative(-2.77f, 1.11f)
                lineTo(11.0f, 4.93f)
                verticalLineTo(3.07f)
                close()
            }
            materialPath {
                moveTo(18.5f, 7.0f)
                lineTo(16.0f, 9.0f)
                verticalLineToRelative(3.0f)
                lineToRelative(2.5f, 2.0f)
                lineToRelative(4.5f, -2.0f)
                verticalLineTo(8.0f)
                lineTo(18.5f, 7.0f)
                close()
                moveTo(21.0f, 10.7f)
                lineToRelative(-2.2f, 0.98f)
                lineTo(18.0f, 11.04f)
                verticalLineTo(9.96f)
                lineToRelative(1.0f, -0.8f)
                lineToRelative(2.0f, 0.44f)
                verticalLineTo(10.7f)
                close()
            }
        }
        return _landslide!!
    }

private var _landslide: ImageVector? = null
