/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.RamenDining: ImageVector
    get() {
        if (_ramenDining != null) {
            return _ramenDining!!
        }
        _ramenDining = materialIcon(name = "Outlined.RamenDining") {
            materialPath {
                moveTo(19.66f, 14.0f)
                curveToRelative(-0.66f, 1.92f, -2.24f, 3.54f, -4.4f, 4.39f)
                lineTo(14.0f, 18.89f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineToRelative(-1.11f)
                lineToRelative(-1.27f, -0.5f)
                curveToRelative(-2.16f, -0.85f, -3.74f, -2.47f, -4.4f, -4.39f)
                horizontalLineTo(19.66f)
                moveTo(22.0f, 2.0f)
                lineTo(4.0f, 3.99f)
                verticalLineTo(12.0f)
                horizontalLineTo(2.0f)
                curveToRelative(0.0f, 3.69f, 2.47f, 6.86f, 6.0f, 8.25f)
                verticalLineTo(22.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(-1.75f)
                curveToRelative(3.53f, -1.39f, 6.0f, -4.56f, 6.0f, -8.25f)
                horizontalLineTo(10.5f)
                verticalLineTo(8.0f)
                horizontalLineTo(22.0f)
                verticalLineTo(6.5f)
                horizontalLineTo(10.5f)
                verticalLineTo(4.78f)
                lineTo(22.0f, 3.51f)
                verticalLineTo(2.0f)
                lineTo(22.0f, 2.0f)
                close()
                moveTo(8.0f, 6.5f)
                verticalLineTo(5.06f)
                lineToRelative(1.0f, -0.11f)
                verticalLineTo(6.5f)
                horizontalLineTo(8.0f)
                lineTo(8.0f, 6.5f)
                close()
                moveTo(5.5f, 6.5f)
                verticalLineTo(5.34f)
                lineToRelative(1.0f, -0.11f)
                verticalLineTo(6.5f)
                horizontalLineTo(5.5f)
                lineTo(5.5f, 6.5f)
                close()
                moveTo(8.0f, 12.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(8.0f)
                lineTo(8.0f, 12.0f)
                close()
                moveTo(5.5f, 12.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(4.0f)
                horizontalLineTo(5.5f)
                lineTo(5.5f, 12.0f)
                close()
            }
        }
        return _ramenDining!!
    }

private var _ramenDining: ImageVector? = null
