/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.VpnKeyOff: ImageVector
    get() {
        if (_vpnKeyOff != null) {
            return _vpnKeyOff!!
        }
        _vpnKeyOff = materialIcon(name = "Outlined.VpnKeyOff") {
            materialPath {
                moveTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineToRelative(2.59f, 2.59f)
                curveTo(2.2f, 7.85f, 1.0f, 9.79f, 1.0f, 12.0f)
                curveToRelative(0.0f, 3.31f, 2.69f, 6.0f, 6.0f, 6.0f)
                curveToRelative(2.22f, 0.0f, 4.15f, -1.21f, 5.19f, -3.0f)
                lineToRelative(7.59f, 7.61f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.81f, 2.81f)
                close()
                moveTo(7.0f, 16.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, -1.79f, -4.0f, -4.0f)
                curveToRelative(0.0f, -1.67f, 1.02f, -3.1f, 2.47f, -3.7f)
                lineToRelative(1.71f, 1.71f)
                curveTo(7.12f, 10.0f, 7.06f, 10.0f, 7.0f, 10.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                curveToRelative(0.0f, -0.06f, 0.0f, -0.12f, -0.01f, -0.18f)
                lineToRelative(1.74f, 1.74f)
                curveTo(10.22f, 14.48f, 9.14f, 16.0f, 7.0f, 16.0f)
                close()
                moveTo(17.0f, 14.17f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(-1.17f)
                lineTo(17.0f, 14.17f)
                close()
                moveTo(13.83f, 11.0f)
                horizontalLineTo(21.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(3.0f)
                lineToRelative(2.0f, 2.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(9.0f)
                horizontalLineTo(11.83f)
                lineTo(13.83f, 11.0f)
                close()
            }
        }
        return _vpnKeyOff!!
    }

private var _vpnKeyOff: ImageVector? = null
