/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AirlineStops: ImageVector
    get() {
        if (_airlineStops != null) {
            return _airlineStops!!
        }
        _airlineStops = materialIcon(name = "Rounded.AirlineStops") {
            materialPath {
                moveTo(15.0f, 18.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(-0.47f, -4.21f, -3.89f, -7.55f, -8.12f, -7.96f)
                curveTo(2.37f, 8.99f, 2.0f, 8.56f, 2.0f, 8.05f)
                curveToRelative(0.0f, -0.59f, 0.52f, -1.06f, 1.11f, -1.0f)
                curveTo(7.03f, 7.44f, 10.37f, 9.87f, 12.0f, 13.3f)
                curveToRelative(1.13f, -2.43f, 2.99f, -4.25f, 4.78f, -5.52f)
                lineToRelative(-1.92f, -1.92f)
                curveTo(14.54f, 5.54f, 14.76f, 5.0f, 15.21f, 5.0f)
                horizontalLineToRelative(5.29f)
                curveTo(20.78f, 5.0f, 21.0f, 5.22f, 21.0f, 5.5f)
                verticalLineToRelative(5.29f)
                curveToRelative(0.0f, 0.45f, -0.54f, 0.67f, -0.85f, 0.35f)
                lineToRelative(-1.94f, -1.94f)
                curveTo(15.93f, 10.78f, 13.45f, 13.3f, 13.0f, 17.0f)
                horizontalLineToRelative(1.0f)
                curveTo(14.55f, 17.0f, 15.0f, 17.45f, 15.0f, 18.0f)
                close()
            }
        }
        return _airlineStops!!
    }

private var _airlineStops: ImageVector? = null
