/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.CastForEducation: ImageVector
    get() {
        if (_castForEducation != null) {
            return _castForEducation!!
        }
        _castForEducation = materialIcon(name = "Rounded.CastForEducation") {
            materialPath {
                moveTo(19.2f, 8.56f)
                lineToRelative(-4.22f, -2.3f)
                curveToRelative(-0.3f, -0.16f, -0.66f, -0.16f, -0.96f, 0.0f)
                lineTo(9.8f, 8.56f)
                curveToRelative(-0.35f, 0.19f, -0.35f, 0.69f, 0.0f, 0.88f)
                lineToRelative(4.22f, 2.3f)
                curveToRelative(0.3f, 0.16f, 0.66f, 0.16f, 0.96f, 0.0f)
                lineToRelative(4.22f, -2.3f)
                curveToRelative(0.34f, -0.19f, 0.34f, -0.69f, 0.0f, -0.88f)
                close()
                moveTo(21.0f, 3.0f)
                lineTo(3.0f, 3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                reflectiveCurveToRelative(1.0f, -0.45f, 1.0f, -1.0f)
                lineTo(3.0f, 6.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-5.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                reflectiveCurveToRelative(0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(23.0f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(14.02f, 12.74f)
                lineTo(11.0f, 11.09f)
                verticalLineToRelative(1.41f)
                curveToRelative(0.0f, 0.37f, 0.2f, 0.7f, 0.52f, 0.88f)
                lineToRelative(2.5f, 1.36f)
                curveToRelative(0.3f, 0.16f, 0.66f, 0.16f, 0.96f, 0.0f)
                lineToRelative(2.5f, -1.36f)
                curveToRelative(0.32f, -0.18f, 0.52f, -0.52f, 0.52f, -0.88f)
                verticalLineToRelative(-1.41f)
                lineToRelative(-3.02f, 1.65f)
                curveToRelative(-0.3f, 0.16f, -0.66f, 0.16f, -0.96f, 0.0f)
                close()
                moveTo(1.0f, 18.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                close()
                moveTo(2.14f, 14.09f)
                curveToRelative(-0.6f, -0.1f, -1.14f, 0.39f, -1.14f, 1.0f)
                curveToRelative(0.0f, 0.49f, 0.36f, 0.9f, 0.85f, 0.98f)
                curveToRelative(2.08f, 0.36f, 3.72f, 2.0f, 4.08f, 4.08f)
                curveToRelative(0.08f, 0.49f, 0.49f, 0.85f, 0.98f, 0.85f)
                curveToRelative(0.61f, 0.0f, 1.09f, -0.54f, 1.0f, -1.14f)
                curveToRelative(-0.48f, -2.96f, -2.82f, -5.29f, -5.77f, -5.77f)
                close()
                moveTo(2.1f, 10.05f)
                curveToRelative(-0.59f, -0.05f, -1.1f, 0.41f, -1.1f, 1.0f)
                curveToRelative(0.0f, 0.51f, 0.38f, 0.94f, 0.88f, 0.99f)
                curveToRelative(4.27f, 0.41f, 7.67f, 3.81f, 8.08f, 8.08f)
                curveToRelative(0.05f, 0.5f, 0.48f, 0.87f, 0.99f, 0.87f)
                curveToRelative(0.6f, 0.0f, 1.06f, -0.52f, 1.0f, -1.11f)
                curveToRelative(-0.53f, -5.19f, -4.66f, -9.31f, -9.85f, -9.83f)
                close()
            }
        }
        return _castForEducation!!
    }

private var _castForEducation: ImageVector? = null
