/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.FiberNew: ImageVector
    get() {
        if (_fiberNew != null) {
            return _fiberNew!!
        }
        _fiberNew = materialIcon(name = "Rounded.FiberNew") {
            materialPath {
                moveTo(20.0f, 4.0f)
                lineTo(4.0f, 4.0f)
                curveToRelative(-1.11f, 0.0f, -1.99f, 0.89f, -1.99f, 2.0f)
                lineTo(2.0f, 18.0f)
                curveToRelative(0.0f, 1.11f, 0.89f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.11f, 0.0f, 2.0f, -0.89f, 2.0f, -2.0f)
                lineTo(22.0f, 6.0f)
                curveToRelative(0.0f, -1.11f, -0.89f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(8.5f, 14.21f)
                curveToRelative(0.0f, 0.43f, -0.36f, 0.79f, -0.79f, 0.79f)
                curveToRelative(-0.25f, 0.0f, -0.49f, -0.12f, -0.64f, -0.33f)
                lineTo(4.75f, 11.5f)
                verticalLineToRelative(2.88f)
                curveToRelative(0.0f, 0.35f, -0.28f, 0.62f, -0.62f, 0.62f)
                reflectiveCurveToRelative(-0.63f, -0.28f, -0.63f, -0.62f)
                lineTo(3.5f, 9.79f)
                curveToRelative(0.0f, -0.43f, 0.36f, -0.79f, 0.79f, -0.79f)
                horizontalLineToRelative(0.05f)
                curveToRelative(0.26f, 0.0f, 0.5f, 0.12f, 0.65f, 0.33f)
                lineToRelative(2.26f, 3.17f)
                lineTo(7.25f, 9.62f)
                curveToRelative(0.0f, -0.34f, 0.28f, -0.62f, 0.63f, -0.62f)
                reflectiveCurveToRelative(0.62f, 0.28f, 0.62f, 0.62f)
                verticalLineToRelative(4.59f)
                close()
                moveTo(13.5f, 9.64f)
                curveToRelative(0.0f, 0.35f, -0.28f, 0.62f, -0.62f, 0.62f)
                lineTo(11.0f, 10.26f)
                verticalLineToRelative(1.12f)
                horizontalLineToRelative(1.88f)
                curveToRelative(0.35f, 0.0f, 0.62f, 0.28f, 0.62f, 0.62f)
                verticalLineToRelative(0.01f)
                curveToRelative(0.0f, 0.35f, -0.28f, 0.62f, -0.62f, 0.62f)
                lineTo(11.0f, 12.63f)
                verticalLineToRelative(1.11f)
                horizontalLineToRelative(1.88f)
                curveToRelative(0.35f, 0.0f, 0.62f, 0.28f, 0.62f, 0.62f)
                curveToRelative(0.0f, 0.35f, -0.28f, 0.62f, -0.62f, 0.62f)
                horizontalLineToRelative(-2.53f)
                curveToRelative(-0.47f, 0.0f, -0.85f, -0.38f, -0.85f, -0.85f)
                verticalLineToRelative(-4.3f)
                curveToRelative(0.0f, -0.45f, 0.38f, -0.83f, 0.85f, -0.83f)
                horizontalLineToRelative(2.53f)
                curveToRelative(0.35f, 0.0f, 0.62f, 0.28f, 0.62f, 0.62f)
                verticalLineToRelative(0.02f)
                close()
                moveTo(20.5f, 14.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineToRelative(-4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                lineTo(14.5f, 9.62f)
                curveToRelative(0.0f, -0.34f, 0.28f, -0.62f, 0.62f, -0.62f)
                reflectiveCurveToRelative(0.62f, 0.28f, 0.62f, 0.62f)
                verticalLineToRelative(3.89f)
                horizontalLineToRelative(1.13f)
                verticalLineToRelative(-2.9f)
                curveToRelative(0.0f, -0.35f, 0.28f, -0.62f, 0.62f, -0.62f)
                reflectiveCurveToRelative(0.62f, 0.28f, 0.62f, 0.62f)
                verticalLineToRelative(2.89f)
                horizontalLineToRelative(1.12f)
                lineTo(19.23f, 9.62f)
                curveToRelative(0.0f, -0.35f, 0.28f, -0.62f, 0.62f, -0.62f)
                reflectiveCurveToRelative(0.62f, 0.28f, 0.62f, 0.62f)
                lineTo(20.47f, 14.0f)
                close()
            }
        }
        return _fiberNew!!
    }

private var _fiberNew: ImageVector? = null
