/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LeakAdd: ImageVector
    get() {
        if (_leakAdd != null) {
            return _leakAdd!!
        }
        _leakAdd = materialIcon(name = "Rounded.LeakAdd") {
            materialPath {
                moveTo(11.05f, 21.0f)
                curveToRelative(0.5f, 0.0f, 0.94f, -0.37f, 0.99f, -0.87f)
                curveToRelative(0.41f, -4.27f, 3.81f, -7.67f, 8.08f, -8.08f)
                curveToRelative(0.5f, -0.05f, 0.88f, -0.48f, 0.88f, -0.99f)
                curveToRelative(0.0f, -0.59f, -0.51f, -1.06f, -1.1f, -1.0f)
                curveToRelative(-5.19f, 0.52f, -9.32f, 4.65f, -9.84f, 9.83f)
                curveToRelative(-0.06f, 0.59f, 0.4f, 1.11f, 0.99f, 1.11f)
                close()
                moveTo(18.0f, 21.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(-3.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, 1.34f, -3.0f, 3.0f)
                close()
                moveTo(15.09f, 21.0f)
                curveToRelative(0.49f, 0.0f, 0.9f, -0.36f, 0.98f, -0.85f)
                curveToRelative(0.36f, -2.08f, 2.0f, -3.72f, 4.08f, -4.08f)
                curveToRelative(0.49f, -0.08f, 0.85f, -0.49f, 0.85f, -0.98f)
                curveToRelative(0.0f, -0.61f, -0.54f, -1.09f, -1.14f, -1.0f)
                curveToRelative(-2.96f, 0.48f, -5.29f, 2.81f, -5.77f, 5.77f)
                curveToRelative(-0.1f, 0.6f, 0.39f, 1.14f, 1.0f, 1.14f)
                close()
                moveTo(12.97f, 3.02f)
                curveToRelative(-0.5f, 0.0f, -0.94f, 0.37f, -0.99f, 0.87f)
                curveToRelative(-0.41f, 4.27f, -3.81f, 7.67f, -8.08f, 8.08f)
                curveToRelative(-0.5f, 0.05f, -0.88f, 0.48f, -0.88f, 0.99f)
                curveToRelative(0.0f, 0.59f, 0.51f, 1.06f, 1.1f, 1.0f)
                curveToRelative(5.19f, -0.52f, 9.32f, -4.65f, 9.84f, -9.83f)
                curveToRelative(0.07f, -0.58f, -0.39f, -1.11f, -0.99f, -1.11f)
                close()
                moveTo(6.03f, 3.02f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                close()
                moveTo(8.94f, 3.02f)
                curveToRelative(-0.49f, 0.0f, -0.9f, 0.36f, -0.98f, 0.85f)
                curveToRelative(-0.36f, 2.08f, -2.0f, 3.72f, -4.08f, 4.08f)
                curveToRelative(-0.49f, 0.09f, -0.85f, 0.49f, -0.85f, 0.99f)
                curveToRelative(0.0f, 0.61f, 0.54f, 1.09f, 1.14f, 1.0f)
                curveToRelative(2.96f, -0.48f, 5.29f, -2.81f, 5.77f, -5.77f)
                curveToRelative(0.09f, -0.61f, -0.4f, -1.15f, -1.0f, -1.15f)
                close()
            }
        }
        return _leakAdd!!
    }

private var _leakAdd: ImageVector? = null
