/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LocalPharmacy: ImageVector
    get() {
        if (_localPharmacy != null) {
            return _localPharmacy!!
        }
        _localPharmacy = materialIcon(name = "Rounded.LocalPharmacy") {
            materialPath {
                moveTo(18.89f, 5.0f)
                horizontalLineToRelative(-0.53f)
                lineToRelative(0.71f, -1.97f)
                curveToRelative(0.24f, -0.65f, -0.1f, -1.37f, -0.75f, -1.6f)
                curveToRelative(-0.65f, -0.24f, -1.37f, 0.1f, -1.61f, 0.75f)
                lineTo(15.69f, 5.0f)
                horizontalLineTo(5.1f)
                curveTo(3.73f, 5.0f, 2.77f, 6.34f, 3.2f, 7.63f)
                lineTo(5.0f, 13.0f)
                lineToRelative(-1.79f, 5.37f)
                curveTo(2.77f, 19.66f, 3.74f, 21.0f, 5.1f, 21.0f)
                horizontalLineToRelative(13.78f)
                curveToRelative(1.36f, 0.0f, 2.33f, -1.34f, 1.9f, -2.63f)
                lineTo(19.0f, 13.0f)
                lineToRelative(1.78f, -5.37f)
                curveTo(21.21f, 6.34f, 20.25f, 5.0f, 18.89f, 5.0f)
                close()
                moveTo(15.0f, 14.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(9.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                close()
            }
        }
        return _localPharmacy!!
    }

private var _localPharmacy: ImageVector? = null
