/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.LocalPolice: ImageVector
    get() {
        if (_localPolice != null) {
            return _localPolice!!
        }
        _localPolice = materialIcon(name = "Rounded.LocalPolice") {
            materialPath {
                moveTo(14.5f, 12.59f)
                lineToRelative(0.63f, 2.73f)
                curveToRelative(0.1f, 0.43f, -0.37f, 0.77f, -0.75f, 0.54f)
                lineTo(12.0f, 14.42f)
                lineToRelative(-2.39f, 1.44f)
                curveToRelative(-0.38f, 0.23f, -0.85f, -0.11f, -0.75f, -0.54f)
                lineTo(9.5f, 12.6f)
                lineToRelative(-2.1f, -1.81f)
                curveTo(7.06f, 10.5f, 7.24f, 9.95f, 7.68f, 9.91f)
                lineToRelative(2.78f, -0.24f)
                lineToRelative(1.08f, -2.56f)
                curveToRelative(0.17f, -0.41f, 0.75f, -0.41f, 0.92f, 0.0f)
                lineToRelative(1.08f, 2.55f)
                lineToRelative(2.78f, 0.24f)
                curveToRelative(0.44f, 0.04f, 0.62f, 0.59f, 0.28f, 0.88f)
                lineTo(14.5f, 12.59f)
                close()
                moveTo(4.19f, 4.47f)
                curveTo(3.47f, 4.79f, 3.0f, 5.51f, 3.0f, 6.3f)
                verticalLineTo(11.0f)
                curveToRelative(0.0f, 5.55f, 3.84f, 10.74f, 9.0f, 12.0f)
                curveToRelative(5.16f, -1.26f, 9.0f, -6.45f, 9.0f, -12.0f)
                verticalLineTo(6.3f)
                curveToRelative(0.0f, -0.79f, -0.47f, -1.51f, -1.19f, -1.83f)
                lineToRelative(-7.0f, -3.11f)
                curveToRelative(-0.52f, -0.23f, -1.11f, -0.23f, -1.62f, 0.0f)
                lineTo(4.19f, 4.47f)
                close()
            }
        }
        return _localPolice!!
    }

private var _localPolice: ImageVector? = null
