/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.MultilineChart: ImageVector
    get() {
        if (_multilineChart != null) {
            return _multilineChart!!
        }
        _multilineChart = materialIcon(name = "Rounded.MultilineChart") {
            materialPath {
                moveTo(21.36f, 6.28f)
                lineToRelative(-0.06f, -0.06f)
                curveToRelative(-0.39f, -0.39f, -1.03f, -0.37f, -1.39f, 0.04f)
                lineToRelative(-2.18f, 2.45f)
                curveTo(15.68f, 6.4f, 12.83f, 5.0f, 9.61f, 5.0f)
                curveToRelative(-2.5f, 0.0f, -4.83f, 0.87f, -6.75f, 2.3f)
                curveToRelative(-0.47f, 0.35f, -0.52f, 1.04f, -0.11f, 1.45f)
                lineToRelative(0.06f, 0.06f)
                curveToRelative(0.33f, 0.33f, 0.86f, 0.39f, 1.23f, 0.11f)
                curveTo(5.63f, 7.72f, 7.54f, 7.0f, 9.61f, 7.0f)
                curveToRelative(2.74f, 0.0f, 5.09f, 1.26f, 6.77f, 3.24f)
                lineToRelative(-2.88f, 3.24f)
                lineToRelative(-3.29f, -3.29f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineToRelative(-6.12f, 6.13f)
                curveToRelative(-0.37f, 0.37f, -0.37f, 0.98f, 0.0f, 1.35f)
                lineToRelative(0.15f, 0.15f)
                curveToRelative(0.37f, 0.37f, 0.98f, 0.37f, 1.35f, 0.0f)
                lineToRelative(5.32f, -5.33f)
                lineToRelative(3.25f, 3.25f)
                curveToRelative(0.41f, 0.41f, 1.07f, 0.39f, 1.45f, -0.04f)
                lineToRelative(3.35f, -3.76f)
                curveToRelative(0.62f, 1.12f, 1.08f, 2.39f, 1.32f, 3.73f)
                curveToRelative(0.08f, 0.47f, 0.47f, 0.82f, 0.95f, 0.82f)
                horizontalLineToRelative(0.09f)
                curveToRelative(0.6f, 0.0f, 1.05f, -0.55f, 0.94f, -1.14f)
                curveToRelative(-0.32f, -1.85f, -0.98f, -3.54f, -1.89f, -5.0f)
                lineTo(21.4f, 7.6f)
                curveToRelative(0.34f, -0.38f, 0.32f, -0.96f, -0.04f, -1.32f)
                close()
            }
        }
        return _multilineChart!!
    }

private var _multilineChart: ImageVector? = null
