/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.RampRight: ImageVector
    get() {
        if (_rampRight != null) {
            return _rampRight!!
        }
        _rampRight = materialIcon(name = "Rounded.RampRight") {
            materialPath {
                moveTo(12.0f, 21.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineTo(6.83f)
                lineToRelative(0.88f, 0.88f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-2.59f, -2.59f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineTo(8.71f, 6.29f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineTo(11.0f, 6.83f)
                verticalLineToRelative(0.0f)
                verticalLineTo(9.0f)
                curveToRelative(0.0f, 3.62f, -2.89f, 6.22f, -4.97f, 7.62f)
                curveToRelative(-0.52f, 0.35f, -0.59f, 1.09f, -0.14f, 1.53f)
                curveToRelative(0.33f, 0.33f, 0.87f, 0.4f, 1.26f, 0.13f)
                curveToRelative(1.59f, -1.06f, 2.89f, -2.28f, 3.85f, -3.59f)
                lineToRelative(0.0f, 5.3f)
                curveTo(11.0f, 20.55f, 11.45f, 21.0f, 12.0f, 21.0f)
                close()
            }
        }
        return _rampRight!!
    }

private var _rampRight: ImageVector? = null
