/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.RemoveModerator: ImageVector
    get() {
        if (_removeModerator != null) {
            return _removeModerator!!
        }
        _removeModerator = materialIcon(name = "Rounded.RemoveModerator") {
            materialPath {
                moveTo(20.0f, 11.09f)
                verticalLineToRelative(-4.7f)
                curveToRelative(0.0f, -0.83f, -0.52f, -1.58f, -1.3f, -1.87f)
                lineToRelative(-6.0f, -2.25f)
                curveToRelative(-0.45f, -0.17f, -0.95f, -0.17f, -1.4f, 0.0f)
                lineTo(6.78f, 3.96f)
                lineToRelative(12.09f, 12.09f)
                curveTo(19.59f, 14.52f, 20.0f, 12.83f, 20.0f, 11.09f)
                close()
                moveTo(20.49f, 20.49f)
                lineTo(3.51f, 3.51f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineTo(4.0f, 6.83f)
                verticalLineToRelative(4.26f)
                curveToRelative(0.0f, 4.83f, 3.13f, 9.37f, 7.43f, 10.75f)
                curveToRelative(0.37f, 0.12f, 0.77f, 0.12f, 1.14f, 0.0f)
                curveToRelative(1.49f, -0.48f, 2.84f, -1.35f, 3.97f, -2.47f)
                lineToRelative(2.53f, 2.53f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveTo(20.88f, 21.51f, 20.88f, 20.88f, 20.49f, 20.49f)
                close()
            }
        }
        return _removeModerator!!
    }

private var _removeModerator: ImageVector? = null
