/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Rsvp: ImageVector
    get() {
        if (_rsvp != null) {
            return _rsvp!!
        }
        _rsvp = materialIcon(name = "Rounded.Rsvp") {
            materialPath {
                moveTo(16.54f, 9.0f)
                lineTo(16.54f, 9.0f)
                curveToRelative(0.48f, 0.0f, 0.83f, 0.46f, 0.69f, 0.92f)
                lineToRelative(-1.27f, 4.36f)
                curveTo(15.84f, 14.71f, 15.44f, 15.0f, 15.0f, 15.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.44f, 0.0f, -0.84f, -0.29f, -0.96f, -0.72f)
                lineToRelative(-1.27f, -4.36f)
                curveTo(12.63f, 9.46f, 12.98f, 9.0f, 13.46f, 9.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.32f, 0.0f, 0.6f, 0.21f, 0.69f, 0.52f)
                lineTo(15.0f, 12.43f)
                lineToRelative(0.85f, -2.91f)
                curveTo(15.94f, 9.21f, 16.22f, 9.0f, 16.54f, 9.0f)
                close()
                moveTo(5.1f, 12.9f)
                lineToRelative(0.49f, 1.14f)
                curveTo(5.78f, 14.49f, 5.45f, 15.0f, 4.96f, 15.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.28f, 0.0f, -0.53f, -0.17f, -0.63f, -0.42f)
                lineTo(3.65f, 13.0f)
                horizontalLineTo(2.5f)
                verticalLineToRelative(1.31f)
                curveTo(2.5f, 14.69f, 2.19f, 15.0f, 1.81f, 15.0f)
                horizontalLineTo(1.69f)
                curveTo(1.31f, 15.0f, 1.0f, 14.69f, 1.0f, 14.31f)
                verticalLineTo(10.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(2.5f)
                curveTo(5.33f, 9.0f, 6.0f, 9.67f, 6.0f, 10.5f)
                verticalLineToRelative(1.0f)
                curveTo(6.0f, 12.1f, 5.6f, 12.65f, 5.1f, 12.9f)
                close()
                moveTo(4.5f, 10.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(10.5f)
                close()
                moveTo(21.5f, 13.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(1.25f)
                curveToRelative(0.0f, 0.41f, -0.34f, 0.75f, -0.75f, 0.75f)
                lineToRelative(0.0f, 0.0f)
                curveTo(18.34f, 15.0f, 18.0f, 14.66f, 18.0f, 14.25f)
                verticalLineTo(10.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(2.5f)
                curveToRelative(0.83f, 0.0f, 1.5f, 0.67f, 1.5f, 1.5f)
                verticalLineToRelative(1.0f)
                curveTo(23.0f, 12.33f, 22.33f, 13.0f, 21.5f, 13.0f)
                close()
                moveTo(21.5f, 10.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(10.5f)
                close()
                moveTo(11.5f, 9.75f)
                lineTo(11.5f, 9.75f)
                curveToRelative(0.0f, 0.41f, -0.34f, 0.75f, -0.75f, 0.75f)
                horizontalLineTo(8.5f)
                verticalLineToRelative(0.75f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineTo(14.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(7.75f)
                curveTo(7.34f, 15.0f, 7.0f, 14.66f, 7.0f, 14.25f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.41f, 0.34f, -0.75f, 0.75f, -0.75f)
                horizontalLineTo(10.0f)
                verticalLineToRelative(-0.75f)
                horizontalLineTo(7.75f)
                curveTo(7.34f, 12.75f, 7.0f, 12.41f, 7.0f, 12.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(2.75f)
                curveTo(11.16f, 9.0f, 11.5f, 9.34f, 11.5f, 9.75f)
                close()
            }
        }
        return _rsvp!!
    }

private var _rsvp: ImageVector? = null
