/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ShuffleOn: ImageVector
    get() {
        if (_shuffleOn != null) {
            return _shuffleOn!!
        }
        _shuffleOn = materialIcon(name = "Rounded.ShuffleOn") {
            materialPath {
                moveTo(21.0f, 1.0f)
                horizontalLineTo(3.0f)
                curveTo(1.9f, 1.0f, 1.0f, 1.9f, 1.0f, 3.0f)
                verticalLineToRelative(18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(18.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(3.0f)
                curveTo(23.0f, 1.9f, 22.1f, 1.0f, 21.0f, 1.0f)
                close()
                moveTo(4.3f, 4.7f)
                curveToRelative(0.39f, -0.39f, 1.02f, -0.39f, 1.41f, 0.0f)
                lineToRelative(4.47f, 4.47f)
                lineToRelative(-1.42f, 1.4f)
                lineTo(4.3f, 6.11f)
                curveTo(3.91f, 5.72f, 3.91f, 5.09f, 4.3f, 4.7f)
                close()
                moveTo(19.59f, 19.5f)
                curveToRelative(0.0f, 0.28f, -0.22f, 0.5f, -0.5f, 0.5f)
                horizontalLineTo(15.3f)
                curveToRelative(-0.45f, 0.0f, -0.67f, -0.54f, -0.36f, -0.85f)
                lineToRelative(1.2f, -1.2f)
                lineToRelative(-3.13f, -3.13f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(3.13f, 3.14f)
                lineToRelative(1.19f, -1.19f)
                curveToRelative(0.31f, -0.32f, 0.85f, -0.1f, 0.85f, 0.35f)
                verticalLineTo(19.5f)
                close()
                moveTo(19.59f, 8.29f)
                curveToRelative(0.0f, 0.45f, -0.54f, 0.67f, -0.85f, 0.36f)
                lineToRelative(-1.19f, -1.19f)
                lineTo(5.7f, 19.29f)
                curveToRelative(-0.39f, 0.39f, -1.02f, 0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, -0.39f, -0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(16.13f, 6.04f)
                lineToRelative(-1.19f, -1.19f)
                curveTo(14.63f, 4.54f, 14.85f, 4.0f, 15.3f, 4.0f)
                horizontalLineToRelative(3.79f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                verticalLineTo(8.29f)
                close()
            }
        }
        return _shuffleOn!!
    }

private var _shuffleOn: ImageVector? = null
