/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.StackedBarChart: ImageVector
    get() {
        if (_stackedBarChart != null) {
            return _stackedBarChart!!
        }
        _stackedBarChart = materialIcon(name = "Rounded.StackedBarChart") {
            materialPath {
                moveTo(6.0f, 10.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(8.5f)
                curveTo(9.0f, 19.33f, 8.33f, 20.0f, 7.5f, 20.0f)
                horizontalLineToRelative(0.0f)
                curveTo(6.67f, 20.0f, 6.0f, 19.33f, 6.0f, 18.5f)
                verticalLineTo(10.0f)
                close()
                moveTo(7.5f, 5.0f)
                lineTo(7.5f, 5.0f)
                curveTo(8.33f, 5.0f, 9.0f, 5.67f, 9.0f, 6.5f)
                verticalLineTo(9.0f)
                horizontalLineTo(6.0f)
                verticalLineTo(6.5f)
                curveTo(6.0f, 5.67f, 6.67f, 5.0f, 7.5f, 5.0f)
                close()
                moveTo(16.0f, 16.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(2.5f)
                curveToRelative(0.0f, 0.83f, -0.67f, 1.5f, -1.5f, 1.5f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                verticalLineTo(16.0f)
                close()
                moveTo(11.0f, 13.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(5.5f)
                curveToRelative(0.0f, 0.83f, -0.67f, 1.5f, -1.5f, 1.5f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                verticalLineTo(13.0f)
                close()
                moveTo(12.5f, 9.0f)
                lineTo(12.5f, 9.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, 0.67f, 1.5f, 1.5f)
                verticalLineTo(12.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(-1.5f)
                curveTo(11.0f, 9.67f, 11.67f, 9.0f, 12.5f, 9.0f)
                close()
                moveTo(19.0f, 15.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(-0.5f)
                curveToRelative(0.0f, -0.83f, 0.67f, -1.5f, 1.5f, -1.5f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, 0.67f, 1.5f, 1.5f)
                verticalLineTo(15.0f)
                close()
            }
        }
        return _stackedBarChart!!
    }

private var _stackedBarChart: ImageVector? = null
