/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.ThumbUpOffAlt: ImageVector
    get() {
        if (_thumbUpOffAlt != null) {
            return _thumbUpOffAlt!!
        }
        _thumbUpOffAlt = materialIcon(name = "Rounded.ThumbUpOffAlt") {
            materialPath {
                moveTo(13.12f, 2.06f)
                lineTo(7.58f, 7.6f)
                curveTo(7.21f, 7.97f, 7.0f, 8.48f, 7.0f, 9.01f)
                verticalLineTo(19.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(9.0f)
                curveToRelative(0.8f, 0.0f, 1.52f, -0.48f, 1.84f, -1.21f)
                lineToRelative(3.26f, -7.61f)
                curveTo(23.94f, 10.2f, 22.49f, 8.0f, 20.34f, 8.0f)
                horizontalLineToRelative(-5.65f)
                lineToRelative(0.95f, -4.58f)
                curveToRelative(0.1f, -0.5f, -0.05f, -1.01f, -0.41f, -1.37f)
                curveTo(14.64f, 1.47f, 13.7f, 1.47f, 13.12f, 2.06f)
                close()
                moveTo(3.0f, 21.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-8.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(8.0f)
                curveTo(1.0f, 20.1f, 1.9f, 21.0f, 3.0f, 21.0f)
                close()
            }
        }
        return _thumbUpOffAlt!!
    }

private var _thumbUpOffAlt: ImageVector? = null
