/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Tsunami: ImageVector
    get() {
        if (_tsunami != null) {
            return _tsunami!!
        }
        _tsunami = materialIcon(name = "Rounded.Tsunami") {
            materialPath {
                moveTo(18.16f, 17.98f)
                curveToRelative(-2.76f, 1.76f, -4.67f, 0.77f, -5.61f, 0.08f)
                curveToRelative(-0.34f, -0.24f, -0.78f, -0.23f, -1.12f, 0.01f)
                curveToRelative(-0.97f, 0.7f, -2.83f, 1.65f, -5.55f, -0.06f)
                curveTo(5.55f, 17.8f, 5.13f, 17.78f, 4.81f, 18.0f)
                curveToRelative(-0.91f, 0.61f, -1.53f, 0.85f, -2.0f, 0.94f)
                curveTo(2.34f, 19.03f, 2.0f, 19.44f, 2.0f, 19.91f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, 0.6f, 0.54f, 1.09f, 1.13f, 0.98f)
                curveToRelative(0.77f, -0.14f, 1.51f, -0.42f, 2.2f, -0.83f)
                curveToRelative(2.04f, 1.21f, 4.63f, 1.21f, 6.67f, 0.0f)
                curveToRelative(2.06f, 1.22f, 4.61f, 1.22f, 6.67f, 0.0f)
                curveToRelative(0.69f, 0.41f, 1.44f, 0.69f, 2.21f, 0.83f)
                curveToRelative(0.59f, 0.11f, 1.13f, -0.38f, 1.13f, -0.98f)
                verticalLineToRelative(-0.01f)
                curveToRelative(0.0f, -0.47f, -0.33f, -0.88f, -0.8f, -0.97f)
                curveToRelative(-0.49f, -0.1f, -1.11f, -0.34f, -2.02f, -0.94f)
                curveTo(18.88f, 17.79f, 18.47f, 17.78f, 18.16f, 17.98f)
                close()
            }
            materialPath {
                moveTo(19.33f, 12.0f)
                horizontalLineTo(21.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                lineToRelative(-1.61f, 0.0f)
                curveToRelative(-1.86f, 0.0f, -3.4f, -1.5f, -3.39f, -3.36f)
                curveToRelative(0.0f, -0.37f, 0.06f, -0.7f, 0.16f, -1.05f)
                curveTo(16.53f, 4.3f, 15.6f, 3.03f, 14.27f, 3.0f)
                curveTo(14.18f, 3.0f, 14.09f, 3.0f, 14.0f, 3.0f)
                curveTo(7.36f, 3.0f, 2.15f, 8.03f, 2.01f, 14.5f)
                lineToRelative(0.0f, 0.03f)
                curveToRelative(-0.04f, 1.13f, 1.07f, 1.98f, 2.14f, 1.6f)
                curveToRelative(0.4f, -0.14f, 0.78f, -0.32f, 1.15f, -0.54f)
                curveToRelative(2.08f, 1.2f, 4.64f, 1.22f, 6.7f, -0.02f)
                curveToRelative(2.06f, 1.22f, 4.61f, 1.22f, 6.67f, 0.0f)
                curveToRelative(0.68f, 0.41f, 1.42f, 0.68f, 2.18f, 0.82f)
                curveToRelative(0.6f, 0.11f, 1.16f, -0.36f, 1.16f, -0.98f)
                verticalLineToRelative(-0.01f)
                curveToRelative(0.0f, -0.46f, -0.32f, -0.88f, -0.78f, -0.97f)
                curveToRelative(-0.49f, -0.09f, -1.12f, -0.33f, -2.03f, -0.94f)
                curveToRelative(-0.31f, -0.21f, -0.73f, -0.22f, -1.05f, -0.01f)
                curveToRelative(-2.73f, 1.74f, -4.63f, 0.77f, -5.58f, 0.09f)
                curveToRelative(-0.35f, -0.25f, -0.81f, -0.26f, -1.16f, -0.01f)
                curveToRelative(-0.15f, 0.11f, -0.09f, 0.06f, -0.32f, 0.2f)
                curveTo(10.39f, 12.82f, 10.0f, 11.7f, 10.0f, 10.5f)
                curveToRelative(0.0f, -2.58f, 1.77f, -4.74f, 4.21f, -5.33f)
                curveTo(14.08f, 5.68f, 14.0f, 6.19f, 14.0f, 6.67f)
                curveTo(14.0f, 9.61f, 16.39f, 12.0f, 19.33f, 12.0f)
                close()
            }
        }
        return _tsunami!!
    }

private var _tsunami: ImageVector? = null
