/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.WifiProtectedSetup: ImageVector
    get() {
        if (_wifiProtectedSetup != null) {
            return _wifiProtectedSetup!!
        }
        _wifiProtectedSetup = materialIcon(name = "Rounded.WifiProtectedSetup") {
            materialPath {
                moveTo(16.7f, 5.3f)
                lineToRelative(1.44f, -1.44f)
                curveToRelative(0.32f, -0.32f, 0.09f, -0.85f, -0.35f, -0.85f)
                horizontalLineTo(11.5f)
                curveToRelative(-0.28f, 0.0f, -0.5f, 0.22f, -0.5f, 0.5f)
                verticalLineTo(9.8f)
                curveToRelative(0.0f, 0.45f, 0.54f, 0.67f, 0.85f, 0.35f)
                lineToRelative(1.45f, -1.45f)
                curveToRelative(1.97f, 1.46f, 3.25f, 3.78f, 3.25f, 6.42f)
                curveToRelative(0.0f, 0.66f, -0.08f, 1.31f, -0.24f, 1.92f)
                curveToRelative(-0.12f, 0.5f, 0.48f, 0.86f, 0.84f, 0.49f)
                curveToRelative(1.48f, -1.53f, 2.4f, -3.61f, 2.4f, -5.91f)
                curveTo(19.55f, 9.11f, 18.44f, 6.86f, 16.7f, 5.3f)
                close()
            }
            materialPath {
                moveTo(12.15f, 13.86f)
                lineTo(10.7f, 15.3f)
                curveToRelative(-1.97f, -1.46f, -3.25f, -3.78f, -3.25f, -6.42f)
                curveToRelative(0.0f, -0.66f, 0.08f, -1.31f, 0.24f, -1.92f)
                curveToRelative(0.12f, -0.5f, -0.48f, -0.86f, -0.84f, -0.49f)
                curveToRelative(-1.48f, 1.53f, -2.4f, 3.61f, -2.4f, 5.91f)
                curveToRelative(0.0f, 2.52f, 1.1f, 4.77f, 2.84f, 6.33f)
                lineToRelative(-1.44f, 1.44f)
                curveToRelative(-0.32f, 0.32f, -0.09f, 0.85f, 0.35f, 0.85f)
                horizontalLineToRelative(6.29f)
                curveToRelative(0.28f, 0.0f, 0.5f, -0.22f, 0.5f, -0.5f)
                verticalLineToRelative(-6.29f)
                curveTo(13.0f, 13.77f, 12.46f, 13.54f, 12.15f, 13.86f)
                close()
            }
        }
        return _wifiProtectedSetup!!
    }

private var _wifiProtectedSetup: ImageVector? = null
