/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.AirlineSeatReclineNormal: ImageVector
    get() {
        if (_airlineSeatReclineNormal != null) {
            return _airlineSeatReclineNormal!!
        }
        _airlineSeatReclineNormal = materialIcon(name = "Sharp.AirlineSeatReclineNormal") {
            materialPath {
                moveTo(7.59f, 5.41f)
                curveToRelative(-0.78f, -0.78f, -0.78f, -2.05f, 0.0f, -2.83f)
                reflectiveCurveToRelative(2.05f, -0.78f, 2.83f, 0.0f)
                reflectiveCurveToRelative(0.78f, 2.05f, 0.0f, 2.83f)
                curveToRelative(-0.79f, 0.79f, -2.05f, 0.79f, -2.83f, 0.0f)
                close()
                moveTo(6.0f, 19.0f)
                lineTo(6.0f, 7.0f)
                lineTo(4.0f, 7.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(11.0f)
                verticalLineToRelative(-2.0f)
                lineTo(6.0f, 19.0f)
                close()
                moveTo(20.0f, 20.07f)
                lineTo(14.93f, 15.0f)
                lineTo(11.5f, 15.0f)
                verticalLineToRelative(-3.68f)
                curveToRelative(1.4f, 1.15f, 3.6f, 2.16f, 5.5f, 2.16f)
                verticalLineToRelative(-2.16f)
                curveToRelative(-1.66f, 0.02f, -3.61f, -0.87f, -4.67f, -2.04f)
                lineToRelative(-1.4f, -1.55f)
                curveToRelative(-0.19f, -0.21f, -0.43f, -0.38f, -0.69f, -0.5f)
                curveToRelative(-0.29f, -0.14f, -0.62f, -0.23f, -0.96f, -0.23f)
                horizontalLineToRelative(-0.03f)
                curveTo(8.01f, 7.0f, 7.0f, 8.01f, 7.0f, 9.25f)
                lineTo(7.0f, 18.0f)
                horizontalLineToRelative(8.07f)
                lineToRelative(3.5f, 3.5f)
                lineTo(20.0f, 20.07f)
                close()
            }
        }
        return _airlineSeatReclineNormal!!
    }

private var _airlineSeatReclineNormal: ImageVector? = null
