/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.CameraEnhance: ImageVector
    get() {
        if (_cameraEnhance != null) {
            return _cameraEnhance!!
        }
        _cameraEnhance = materialIcon(name = "Sharp.CameraEnhance") {
            materialPath {
                moveTo(16.83f, 5.0f)
                lineTo(15.0f, 3.0f)
                lineTo(9.0f, 3.0f)
                lineTo(7.17f, 5.0f)
                lineTo(2.0f, 5.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(20.0f)
                lineTo(22.0f, 5.0f)
                horizontalLineToRelative(-5.17f)
                close()
                moveTo(12.0f, 18.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, -2.24f, -5.0f, -5.0f)
                reflectiveCurveToRelative(2.24f, -5.0f, 5.0f, -5.0f)
                reflectiveCurveToRelative(5.0f, 2.24f, 5.0f, 5.0f)
                reflectiveCurveToRelative(-2.24f, 5.0f, -5.0f, 5.0f)
                close()
                moveTo(12.0f, 9.0f)
                lineToRelative(-1.25f, 2.75f)
                lineTo(8.0f, 13.0f)
                lineToRelative(2.75f, 1.25f)
                lineTo(12.0f, 17.0f)
                lineToRelative(1.25f, -2.75f)
                lineTo(16.0f, 13.0f)
                lineToRelative(-2.75f, -1.25f)
                close()
            }
        }
        return _cameraEnhance!!
    }

private var _cameraEnhance: ImageVector? = null
