/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.FaceRetouchingNatural: ImageVector
    get() {
        if (_faceRetouchingNatural != null) {
            return _faceRetouchingNatural!!
        }
        _faceRetouchingNatural = materialIcon(name = "Sharp.FaceRetouchingNatural") {
            materialPath {
                moveTo(9.0f, 13.0f)
                moveToRelative(-1.25f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, 2.5f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, -2.5f, 0.0f)
            }
            materialPath {
                moveTo(19.85f, 10.59f)
                curveTo(20.79f, 15.4f, 17.01f, 20.0f, 12.0f, 20.0f)
                curveToRelative(-4.41f, 0.0f, -8.0f, -3.59f, -8.0f, -8.0f)
                curveToRelative(0.0f, -0.39f, 3.87f, -1.12f, 5.74f, -5.69f)
                curveToRelative(3.42f, 4.19f, 8.07f, 3.73f, 9.09f, 3.59f)
                lineToRelative(-1.48f, -3.25f)
                lineTo(12.63f, 4.5f)
                lineToRelative(3.5f, -1.59f)
                curveTo(9.51f, -0.14f, 2.0f, 4.77f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                curveToRelative(7.21f, 0.0f, 12.12f, -7.45f, 9.1f, -14.13f)
                lineTo(19.85f, 10.59f)
                close()
            }
            materialPath {
                moveTo(15.0f, 13.0f)
                moveToRelative(-1.25f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, 2.5f, 0.0f)
                arcToRelative(1.25f, 1.25f, 0.0f, true, true, -2.5f, 0.0f)
            }
            materialPath {
                moveTo(20.6f, 5.6f)
                lineTo(19.5f, 8.0f)
                lineToRelative(-1.1f, -2.4f)
                lineTo(16.0f, 4.5f)
                lineToRelative(2.4f, -1.1f)
                lineTo(19.5f, 1.0f)
                lineToRelative(1.1f, 2.4f)
                lineTo(23.0f, 4.5f)
                lineTo(20.6f, 5.6f)
                close()
            }
        }
        return _faceRetouchingNatural!!
    }

private var _faceRetouchingNatural: ImageVector? = null
