/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PanToolAlt: ImageVector
    get() {
        if (_panToolAlt != null) {
            return _panToolAlt!!
        }
        _panToolAlt = materialIcon(name = "Sharp.PanToolAlt") {
            materialPath {
                moveTo(20.18f, 13.4f)
                lineTo(19.1f, 21.0f)
                horizontalLineToRelative(-9.0f)
                lineTo(5.0f, 15.62f)
                lineToRelative(1.22f, -1.23f)
                lineTo(10.0f, 15.24f)
                verticalLineTo(4.5f)
                curveTo(10.0f, 3.67f, 10.67f, 3.0f, 11.5f, 3.0f)
                reflectiveCurveTo(13.0f, 3.67f, 13.0f, 4.5f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.38f)
                lineTo(20.18f, 13.4f)
                close()
            }
        }
        return _panToolAlt!!
    }

private var _panToolAlt: ImageVector? = null
