/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PanoramaVertical: ImageVector
    get() {
        if (_panoramaVertical != null) {
            return _panoramaVertical!!
        }
        _panoramaVertical = materialIcon(name = "Sharp.PanoramaVertical") {
            materialPath {
                moveTo(17.46f, 4.0f)
                curveToRelative(-0.77f, 2.6f, -1.16f, 5.28f, -1.16f, 8.0f)
                curveToRelative(0.0f, 2.72f, 0.39f, 5.41f, 1.16f, 8.0f)
                horizontalLineTo(6.55f)
                curveToRelative(0.77f, -2.6f, 1.16f, -5.28f, 1.16f, -8.0f)
                curveToRelative(0.0f, -2.72f, -0.39f, -5.41f, -1.16f, -8.0f)
                horizontalLineToRelative(10.91f)
                moveToRelative(2.78f, -2.0f)
                horizontalLineTo(3.77f)
                reflectiveCurveToRelative(0.26f, 0.77f, 0.3f, 0.88f)
                curveTo(5.16f, 5.82f, 5.71f, 8.91f, 5.71f, 12.0f)
                reflectiveCurveToRelative(-0.55f, 6.18f, -1.64f, 9.12f)
                curveToRelative(-0.04f, 0.11f, -0.3f, 0.88f, -0.3f, 0.88f)
                horizontalLineToRelative(16.47f)
                reflectiveCurveToRelative(-0.26f, -0.77f, -0.3f, -0.88f)
                curveToRelative(-1.09f, -2.94f, -1.64f, -6.03f, -1.64f, -9.12f)
                reflectiveCurveToRelative(0.55f, -6.18f, 1.64f, -9.12f)
                curveToRelative(0.04f, -0.11f, 0.3f, -0.88f, 0.3f, -0.88f)
                close()
            }
        }
        return _panoramaVertical!!
    }

private var _panoramaVertical: ImageVector? = null
