/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PhoneMissed: ImageVector
    get() {
        if (_phoneMissed != null) {
            return _phoneMissed!!
        }
        _phoneMissed = materialIcon(name = "Sharp.PhoneMissed") {
            materialPath {
                moveTo(23.32f, 16.67f)
                curveToRelative(-2.95f, -2.79f, -6.93f, -4.51f, -11.31f, -4.51f)
                curveToRelative(-4.39f, 0.0f, -8.37f, 1.72f, -11.31f, 4.51f)
                lineToRelative(-0.69f, 0.69f)
                lineTo(3.65f, 21.0f)
                lineToRelative(3.93f, -2.72f)
                lineToRelative(-0.01f, -3.49f)
                curveToRelative(1.4f, -0.45f, 2.9f, -0.7f, 4.44f, -0.7f)
                curveToRelative(1.55f, 0.0f, 3.04f, 0.24f, 4.44f, 0.7f)
                lineToRelative(-0.01f, 3.49f)
                lineTo(20.37f, 21.0f)
                lineToRelative(3.64f, -3.64f)
                curveToRelative(0.0f, -0.01f, -0.52f, -0.52f, -0.69f, -0.69f)
                close()
                moveTo(7.0f, 6.43f)
                lineToRelative(4.94f, 4.94f)
                lineToRelative(7.07f, -7.07f)
                lineToRelative(-1.41f, -1.42f)
                lineToRelative(-5.66f, 5.66f)
                lineTo(8.4f, 5.0f)
                horizontalLineTo(11.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(2.0f)
                close()
            }
        }
        return _phoneMissed!!
    }

private var _phoneMissed: ImageVector? = null
