/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SettingsSuggest: ImageVector
    get() {
        if (_settingsSuggest != null) {
            return _settingsSuggest!!
        }
        _settingsSuggest = materialIcon(name = "Sharp.SettingsSuggest") {
            materialPath {
                moveTo(17.41f, 6.59f)
                lineTo(15.0f, 5.5f)
                lineToRelative(2.41f, -1.09f)
                lineTo(18.5f, 2.0f)
                lineToRelative(1.09f, 2.41f)
                lineTo(22.0f, 5.5f)
                lineToRelative(-2.41f, 1.09f)
                lineTo(18.5f, 9.0f)
                lineTo(17.41f, 6.59f)
                close()
                moveTo(21.28f, 12.72f)
                lineTo(20.5f, 11.0f)
                lineToRelative(-0.78f, 1.72f)
                lineTo(18.0f, 13.5f)
                lineToRelative(1.72f, 0.78f)
                lineTo(20.5f, 16.0f)
                lineToRelative(0.78f, -1.72f)
                lineTo(23.0f, 13.5f)
                lineTo(21.28f, 12.72f)
                close()
                moveTo(16.24f, 14.37f)
                lineToRelative(1.94f, 1.47f)
                lineToRelative(-2.5f, 4.33f)
                lineToRelative(-2.24f, -0.94f)
                curveToRelative(-0.2f, 0.13f, -0.42f, 0.26f, -0.64f, 0.37f)
                lineTo(12.5f, 22.0f)
                horizontalLineToRelative(-5.0f)
                lineToRelative(-0.3f, -2.41f)
                curveToRelative(-0.22f, -0.11f, -0.43f, -0.23f, -0.64f, -0.37f)
                lineToRelative(-2.24f, 0.94f)
                lineToRelative(-2.5f, -4.33f)
                lineToRelative(1.94f, -1.47f)
                curveTo(3.75f, 14.25f, 3.75f, 14.12f, 3.75f, 14.0f)
                reflectiveCurveToRelative(0.0f, -0.25f, 0.01f, -0.37f)
                lineToRelative(-1.94f, -1.47f)
                lineToRelative(2.5f, -4.33f)
                lineToRelative(2.24f, 0.94f)
                curveToRelative(0.2f, -0.13f, 0.42f, -0.26f, 0.64f, -0.37f)
                lineTo(7.5f, 6.0f)
                horizontalLineToRelative(5.0f)
                lineToRelative(0.3f, 2.41f)
                curveToRelative(0.22f, 0.11f, 0.43f, 0.23f, 0.64f, 0.37f)
                lineToRelative(2.24f, -0.94f)
                lineToRelative(2.5f, 4.33f)
                lineToRelative(-1.94f, 1.47f)
                curveToRelative(0.01f, 0.12f, 0.01f, 0.24f, 0.01f, 0.37f)
                reflectiveCurveTo(16.25f, 14.25f, 16.24f, 14.37f)
                close()
                moveTo(13.0f, 14.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveToRelative(-3.0f, 1.34f, -3.0f, 3.0f)
                reflectiveCurveToRelative(1.34f, 3.0f, 3.0f, 3.0f)
                reflectiveCurveTo(13.0f, 15.66f, 13.0f, 14.0f)
                close()
            }
        }
        return _settingsSuggest!!
    }

private var _settingsSuggest: ImageVector? = null
