/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SwipeLeft: ImageVector
    get() {
        if (_swipeLeft != null) {
            return _swipeLeft!!
        }
        _swipeLeft = materialIcon(name = "Sharp.SwipeLeft") {
            materialPath {
                moveTo(20.18f, 15.4f)
                lineTo(19.1f, 23.0f)
                horizontalLineToRelative(-9.0f)
                lineTo(5.0f, 17.62f)
                lineToRelative(1.22f, -1.23f)
                lineTo(10.0f, 17.24f)
                verticalLineTo(6.5f)
                curveTo(10.0f, 5.67f, 10.67f, 5.0f, 11.5f, 5.0f)
                reflectiveCurveTo(13.0f, 5.67f, 13.0f, 6.5f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.38f)
                lineTo(20.18f, 15.4f)
                close()
                moveTo(12.0f, 2.5f)
                curveToRelative(4.74f, 0.0f, 7.67f, 2.52f, 8.43f, 4.5f)
                horizontalLineTo(22.0f)
                curveToRelative(-0.73f, -2.88f, -4.51f, -6.0f, -10.0f, -6.0f)
                curveTo(8.78f, 1.0f, 5.82f, 2.13f, 3.5f, 4.02f)
                verticalLineTo(2.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(5.0f)
                verticalLineTo(5.5f)
                horizontalLineTo(4.09f)
                curveTo(6.21f, 3.64f, 8.97f, 2.5f, 12.0f, 2.5f)
                close()
            }
        }
        return _swipeLeft!!
    }

private var _swipeLeft: ImageVector? = null
