/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.AdsClick: ImageVector
    get() {
        if (_adsClick != null) {
            return _adsClick!!
        }
        _adsClick = materialIcon(name = "TwoTone.AdsClick") {
            materialPath {
                moveTo(11.71f, 17.99f)
                curveTo(8.53f, 17.84f, 6.0f, 15.22f, 6.0f, 12.0f)
                curveToRelative(0.0f, -3.31f, 2.69f, -6.0f, 6.0f, -6.0f)
                curveToRelative(3.22f, 0.0f, 5.84f, 2.53f, 5.99f, 5.71f)
                lineToRelative(-2.1f, -0.63f)
                curveTo(15.48f, 9.31f, 13.89f, 8.0f, 12.0f, 8.0f)
                curveToRelative(-2.21f, 0.0f, -4.0f, 1.79f, -4.0f, 4.0f)
                curveToRelative(0.0f, 1.89f, 1.31f, 3.48f, 3.08f, 3.89f)
                lineTo(11.71f, 17.99f)
                close()
                moveTo(22.0f, 12.0f)
                curveToRelative(0.0f, 0.3f, -0.01f, 0.6f, -0.04f, 0.9f)
                lineToRelative(-1.97f, -0.59f)
                curveTo(20.0f, 12.21f, 20.0f, 12.1f, 20.0f, 12.0f)
                curveToRelative(0.0f, -4.42f, -3.58f, -8.0f, -8.0f, -8.0f)
                reflectiveCurveToRelative(-8.0f, 3.58f, -8.0f, 8.0f)
                reflectiveCurveToRelative(3.58f, 8.0f, 8.0f, 8.0f)
                curveToRelative(0.1f, 0.0f, 0.21f, 0.0f, 0.31f, -0.01f)
                lineToRelative(0.59f, 1.97f)
                curveTo(12.6f, 21.99f, 12.3f, 22.0f, 12.0f, 22.0f)
                curveTo(6.48f, 22.0f, 2.0f, 17.52f, 2.0f, 12.0f)
                curveTo(2.0f, 6.48f, 6.48f, 2.0f, 12.0f, 2.0f)
                reflectiveCurveTo(22.0f, 6.48f, 22.0f, 12.0f)
                close()
                moveTo(18.23f, 16.26f)
                lineTo(22.0f, 15.0f)
                lineToRelative(-10.0f, -3.0f)
                lineToRelative(3.0f, 10.0f)
                lineToRelative(1.26f, -3.77f)
                lineToRelative(4.27f, 4.27f)
                lineToRelative(1.98f, -1.98f)
                lineTo(18.23f, 16.26f)
                close()
            }
        }
        return _adsClick!!
    }

private var _adsClick: ImageVector? = null
