/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ClosedCaptionDisabled: ImageVector
    get() {
        if (_closedCaptionDisabled != null) {
            return _closedCaptionDisabled!!
        }
        _closedCaptionDisabled = materialIcon(name = "TwoTone.ClosedCaptionDisabled") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(8.83f, 6.0f)
                horizontalLineTo(19.0f)
                verticalLineToRelative(10.17f)
                lineToRelative(-1.4f, -1.4f)
                curveTo(17.84f, 14.59f, 18.0f, 14.32f, 18.0f, 14.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(0.5f)
                horizontalLineToRelative(-0.17f)
                lineToRelative(-1.83f, -1.83f)
                verticalLineTo(10.5f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(11.0f)
                horizontalLineTo(18.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-3.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.17f)
                lineTo(8.83f, 6.0f)
                close()
                moveTo(7.5f, 13.5f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(0.67f)
                lineToRelative(-2.5f, -2.5f)
                horizontalLineTo(7.5f)
                verticalLineTo(13.5f)
                close()
                moveTo(11.0f, 14.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-4.0f)
                curveToRelative(0.0f, -0.32f, 0.16f, -0.59f, 0.4f, -0.78f)
                lineTo(5.0f, 7.83f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(10.17f)
                lineTo(11.0f, 13.83f)
                verticalLineTo(14.0f)
                close()
            }
            materialPath {
                moveTo(6.83f, 4.0f)
                horizontalLineTo(19.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 0.05f, -0.01f, 0.1f, -0.02f, 0.16f)
                lineTo(19.0f, 16.17f)
                verticalLineTo(6.0f)
                horizontalLineTo(8.83f)
                lineTo(6.83f, 4.0f)
                close()
                moveTo(19.78f, 22.61f)
                lineTo(17.17f, 20.0f)
                horizontalLineTo(5.0f)
                curveToRelative(-1.11f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -0.05f, 0.02f, -0.1f, 0.02f, -0.15f)
                lineTo(1.39f, 4.22f)
                lineToRelative(1.41f, -1.41f)
                lineTo(18.0f, 18.0f)
                lineToRelative(1.82f, 1.82f)
                lineToRelative(1.37f, 1.37f)
                lineTo(19.78f, 22.61f)
                close()
                moveTo(7.5f, 13.5f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(0.67f)
                lineToRelative(-2.5f, -2.5f)
                horizontalLineTo(7.5f)
                verticalLineTo(13.5f)
                close()
                moveTo(15.17f, 18.0f)
                lineTo(11.0f, 13.83f)
                verticalLineTo(14.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-4.0f)
                curveToRelative(0.0f, -0.32f, 0.16f, -0.59f, 0.4f, -0.78f)
                lineTo(5.0f, 7.83f)
                verticalLineTo(18.0f)
                horizontalLineTo(15.17f)
                close()
                moveTo(18.0f, 14.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(0.5f)
                horizontalLineToRelative(-0.17f)
                lineToRelative(1.28f, 1.28f)
                curveTo(17.84f, 14.59f, 18.0f, 14.32f, 18.0f, 14.0f)
                close()
                moveTo(14.5f, 11.67f)
                verticalLineTo(10.5f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(11.0f)
                horizontalLineTo(18.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-3.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(0.17f)
                lineTo(14.5f, 11.67f)
                close()
            }
        }
        return _closedCaptionDisabled!!
    }

private var _closedCaptionDisabled: ImageVector? = null
