/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ImportantDevices: ImageVector
    get() {
        if (_importantDevices != null) {
            return _importantDevices!!
        }
        _importantDevices = materialIcon(name = "TwoTone.ImportantDevices") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(18.0f, 13.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(7.0f)
                horizontalLineToRelative(-5.0f)
                close()
            }
            materialPath {
                moveTo(23.0f, 11.01f)
                lineTo(18.0f, 11.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(9.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(5.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-9.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -0.99f, -1.0f, -0.99f)
                close()
                moveTo(23.0f, 20.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineToRelative(-7.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(7.0f)
                close()
                moveTo(2.0f, 4.0f)
                horizontalLineToRelative(18.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(2.0f)
                lineTo(22.0f, 4.0f)
                curveToRelative(0.0f, -1.11f, -0.9f, -2.0f, -2.0f, -2.0f)
                lineTo(2.0f, 2.0f)
                curveTo(0.89f, 2.0f, 0.0f, 2.89f, 0.0f, 4.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(2.0f)
                lineTo(7.0f, 20.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                lineTo(2.0f, 16.0f)
                lineTo(2.0f, 4.0f)
                close()
                moveTo(11.0f, 6.0f)
                lineToRelative(-0.97f, 3.0f)
                lineTo(7.0f, 9.0f)
                lineToRelative(2.47f, 1.76f)
                lineToRelative(-0.94f, 2.91f)
                lineToRelative(2.47f, -1.8f)
                lineToRelative(2.47f, 1.8f)
                lineToRelative(-0.94f, -2.91f)
                lineTo(15.0f, 9.0f)
                horizontalLineToRelative(-3.03f)
                close()
            }
        }
        return _importantDevices!!
    }

private var _importantDevices: ImageVector? = null
