/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.NewLabel: ImageVector
    get() {
        if (_newLabel != null) {
            return _newLabel!!
        }
        _newLabel = materialIcon(name = "TwoTone.NewLabel") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 17.0f)
                lineToRelative(0.0f, -4.0f)
                lineToRelative(-3.0f, 0.0f)
                lineToRelative(0.0f, -3.0f)
                lineToRelative(-4.0f, 0.0f)
                lineToRelative(0.0f, -3.0f)
                lineToRelative(10.0f, 0.0f)
                lineToRelative(3.55f, 5.0f)
                lineToRelative(-3.55f, 5.0f)
                close()
            }
            materialPath {
                moveTo(21.0f, 12.0f)
                lineToRelative(-4.37f, 6.16f)
                curveTo(16.26f, 18.68f, 15.65f, 19.0f, 15.0f, 19.0f)
                horizontalLineToRelative(-3.0f)
                lineToRelative(0.0f, -2.0f)
                horizontalLineToRelative(3.0f)
                lineToRelative(3.55f, -5.0f)
                lineTo(15.0f, 7.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(3.0f)
                horizontalLineTo(3.0f)
                verticalLineTo(7.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(0.65f, 0.0f, 1.26f, 0.31f, 1.63f, 0.84f)
                lineTo(21.0f, 12.0f)
                close()
                moveTo(10.0f, 15.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(3.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(3.0f)
                verticalLineTo(15.0f)
                close()
            }
        }
        return _newLabel!!
    }

private var _newLabel: ImageVector? = null
