/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.PowerOff: ImageVector
    get() {
        if (_powerOff != null) {
            return _powerOff!!
        }
        _powerOff = materialIcon(name = "TwoTone.PowerOff") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.12f, 9.0f)
                lineTo(16.0f, 12.88f)
                lineTo(16.0f, 9.0f)
                close()
                moveTo(11.5f, 17.17f)
                lineTo(11.5f, 19.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(-1.83f)
                lineToRelative(1.07f, -1.06f)
                lineTo(8.0f, 10.54f)
                verticalLineToRelative(3.11f)
                close()
            }
            materialPath {
                moveTo(10.0f, 3.0f)
                lineTo(8.0f, 3.0f)
                verticalLineToRelative(1.88f)
                lineToRelative(2.0f, 2.0f)
                close()
                moveTo(16.0f, 9.0f)
                verticalLineToRelative(3.88f)
                lineToRelative(1.8f, 1.8f)
                lineToRelative(0.2f, -0.2f)
                lineTo(18.0f, 9.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                lineTo(16.0f, 3.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-3.88f)
                lineToRelative(2.0f, 2.0f)
                lineTo(16.0f, 9.0f)
                close()
                moveTo(4.12f, 3.84f)
                lineTo(2.71f, 5.25f)
                lineTo(6.0f, 8.54f)
                verticalLineToRelative(5.96f)
                lineTo(9.5f, 18.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(-3.0f)
                lineToRelative(0.48f, -0.48f)
                lineToRelative(4.47f, 4.47f)
                lineToRelative(1.41f, -1.41f)
                lineTo(4.12f, 3.84f)
                close()
                moveTo(12.5f, 17.17f)
                lineTo(12.5f, 19.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-1.83f)
                lineTo(8.0f, 13.65f)
                verticalLineToRelative(-3.11f)
                lineToRelative(5.57f, 5.57f)
                lineToRelative(-1.07f, 1.06f)
                close()
            }
        }
        return _powerOff!!
    }

private var _powerOff: ImageVector? = null
