/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.RealEstateAgent: ImageVector
    get() {
        if (_realEstateAgent != null) {
            return _realEstateAgent!!
        }
        _realEstateAgent = materialIcon(name = "TwoTone.RealEstateAgent") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(10.5f, 9.44f)
                lineToRelative(5.32f, 1.99f)
                curveToRelative(1.24f, 0.46f, 2.21f, 1.41f, 2.74f, 2.57f)
                lineTo(19.0f, 14.0f)
                verticalLineTo(7.5f)
                lineTo(14.0f, 4.0f)
                lineTo(9.0f, 7.5f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(0.33f)
                lineTo(10.5f, 9.44f)
                close()
                moveTo(14.5f, 7.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(14.5f, 9.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(9.0f)
                close()
                moveTo(12.5f, 7.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(12.5f, 9.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(9.0f)
                close()
                moveTo(3.0f, 13.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(7.0f)
                horizontalLineTo(3.0f)
                verticalLineTo(13.0f)
                close()
                moveTo(19.9f, 18.57f)
                lineToRelative(-5.93f, 1.84f)
                lineTo(7.0f, 18.48f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(1.61f)
                lineToRelative(5.82f, 2.17f)
                curveTo(14.77f, 15.3f, 15.0f, 15.63f, 15.0f, 16.0f)
                curveToRelative(0.0f, 0.0f, -1.99f, -0.05f, -2.3f, -0.15f)
                lineToRelative(-2.38f, -0.79f)
                lineToRelative(-0.63f, 1.9f)
                lineToRelative(2.38f, 0.79f)
                curveToRelative(0.51f, 0.17f, 1.04f, 0.26f, 1.58f, 0.26f)
                horizontalLineTo(19.0f)
                curveTo(19.39f, 18.01f, 19.74f, 18.24f, 19.9f, 18.57f)
                close()
            }
            materialPath {
                moveTo(15.5f, 7.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(13.5f, 7.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(15.5f, 9.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(9.0f)
                close()
                moveTo(13.5f, 9.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(9.0f)
                close()
                moveTo(21.0f, 6.5f)
                verticalLineTo(14.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(7.5f)
                lineTo(14.0f, 4.0f)
                lineTo(9.0f, 7.5f)
                verticalLineTo(9.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(6.5f)
                lineToRelative(7.0f, -5.0f)
                lineTo(21.0f, 6.5f)
                close()
                moveTo(19.0f, 16.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(0.0f, -1.2f, -0.75f, -2.28f, -1.87f, -2.7f)
                lineTo(8.97f, 11.0f)
                horizontalLineTo(1.0f)
                verticalLineToRelative(11.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-1.44f)
                lineToRelative(7.0f, 1.94f)
                lineToRelative(8.0f, -2.5f)
                verticalLineToRelative(-1.0f)
                curveTo(22.0f, 17.34f, 20.66f, 16.0f, 19.0f, 16.0f)
                close()
                moveTo(3.0f, 20.0f)
                verticalLineToRelative(-7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(7.0f)
                horizontalLineTo(3.0f)
                close()
                moveTo(13.97f, 20.41f)
                lineTo(7.0f, 18.48f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(1.61f)
                lineToRelative(5.82f, 2.17f)
                curveTo(14.77f, 15.3f, 15.0f, 15.63f, 15.0f, 16.0f)
                curveToRelative(0.0f, 0.0f, -1.99f, -0.05f, -2.3f, -0.15f)
                lineToRelative(-2.38f, -0.79f)
                lineToRelative(-0.63f, 1.9f)
                lineToRelative(2.38f, 0.79f)
                curveToRelative(0.51f, 0.17f, 1.04f, 0.26f, 1.58f, 0.26f)
                horizontalLineTo(19.0f)
                curveToRelative(0.39f, 0.0f, 0.74f, 0.23f, 0.9f, 0.56f)
                lineTo(13.97f, 20.41f)
                close()
            }
        }
        return _realEstateAgent!!
    }

private var _realEstateAgent: ImageVector? = null
