/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.AppSettingsAlt: ImageVector
    get() {
        if (_appSettingsAlt != null) {
            return _appSettingsAlt!!
        }
        _appSettingsAlt = materialIcon(name = "Filled.AppSettingsAlt") {
            materialPath {
                moveTo(21.81f, 12.74f)
                lineToRelative(-0.82f, -0.63f)
                verticalLineToRelative(-0.22f)
                lineToRelative(0.8f, -0.63f)
                curveToRelative(0.16f, -0.12f, 0.2f, -0.34f, 0.1f, -0.51f)
                lineToRelative(-0.85f, -1.48f)
                curveToRelative(-0.07f, -0.13f, -0.21f, -0.2f, -0.35f, -0.2f)
                curveToRelative(-0.05f, 0.0f, -0.1f, 0.01f, -0.15f, 0.03f)
                lineToRelative(-0.95f, 0.38f)
                curveToRelative(-0.08f, -0.05f, -0.11f, -0.07f, -0.19f, -0.11f)
                lineToRelative(-0.15f, -1.01f)
                curveToRelative(-0.03f, -0.21f, -0.2f, -0.36f, -0.4f, -0.36f)
                horizontalLineToRelative(-1.71f)
                curveToRelative(-0.2f, 0.0f, -0.37f, 0.15f, -0.4f, 0.34f)
                lineToRelative(-0.14f, 1.01f)
                curveToRelative(-0.03f, 0.02f, -0.07f, 0.03f, -0.1f, 0.05f)
                lineToRelative(-0.09f, 0.06f)
                lineToRelative(-0.95f, -0.38f)
                curveToRelative(-0.05f, -0.02f, -0.1f, -0.03f, -0.15f, -0.03f)
                curveToRelative(-0.14f, 0.0f, -0.27f, 0.07f, -0.35f, 0.2f)
                lineToRelative(-0.85f, 1.48f)
                curveToRelative(-0.1f, 0.17f, -0.06f, 0.39f, 0.1f, 0.51f)
                lineToRelative(0.8f, 0.63f)
                verticalLineToRelative(0.23f)
                lineToRelative(-0.8f, 0.63f)
                curveToRelative(-0.16f, 0.12f, -0.2f, 0.34f, -0.1f, 0.51f)
                lineToRelative(0.85f, 1.48f)
                curveToRelative(0.07f, 0.13f, 0.21f, 0.2f, 0.35f, 0.2f)
                curveToRelative(0.05f, 0.0f, 0.1f, -0.01f, 0.15f, -0.03f)
                lineToRelative(0.95f, -0.37f)
                curveToRelative(0.08f, 0.05f, 0.12f, 0.07f, 0.2f, 0.11f)
                lineToRelative(0.15f, 1.01f)
                curveToRelative(0.03f, 0.2f, 0.2f, 0.34f, 0.4f, 0.34f)
                horizontalLineToRelative(1.71f)
                curveToRelative(0.2f, 0.0f, 0.37f, -0.15f, 0.4f, -0.34f)
                lineToRelative(0.15f, -1.01f)
                curveToRelative(0.03f, -0.02f, 0.07f, -0.03f, 0.1f, -0.05f)
                lineToRelative(0.09f, -0.06f)
                lineToRelative(0.95f, 0.38f)
                curveToRelative(0.05f, 0.02f, 0.1f, 0.03f, 0.15f, 0.03f)
                curveToRelative(0.14f, 0.0f, 0.27f, -0.07f, 0.35f, -0.2f)
                lineToRelative(0.85f, -1.48f)
                curveToRelative(0.1f, -0.17f, 0.06f, -0.39f, -0.1f, -0.51f)
                close()
                moveTo(18.0f, 13.5f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveToRelative(0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveToRelative(-0.67f, 1.5f, -1.5f, 1.5f)
                close()
                moveTo(17.0f, 17.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                horizontalLineTo(7.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(3.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(6.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(-1.0f)
                close()
            }
        }
        return _appSettingsAlt!!
    }

private var _appSettingsAlt: ImageVector? = null
