/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.AutoFixOff: ImageVector
    get() {
        if (_autoFixOff != null) {
            return _autoFixOff!!
        }
        _autoFixOff = materialIcon(name = "Filled.AutoFixOff") {
            materialPath {
                moveTo(23.0f, 1.0f)
                lineToRelative(-2.5f, 1.4f)
                lineTo(18.0f, 1.0f)
                lineToRelative(1.4f, 2.5f)
                lineTo(18.0f, 6.0f)
                lineToRelative(2.5f, -1.4f)
                lineTo(23.0f, 6.0f)
                lineToRelative(-1.4f, -2.5f)
                lineTo(23.0f, 1.0f)
                close()
                moveTo(14.66f, 7.22f)
                lineToRelative(2.12f, 2.12f)
                lineToRelative(-2.44f, 2.44f)
                lineToRelative(0.81f, 0.81f)
                lineToRelative(2.55f, -2.55f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineToRelative(-2.34f, -2.34f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                lineTo(11.4f, 8.84f)
                lineToRelative(0.81f, 0.81f)
                lineToRelative(2.45f, -2.43f)
                close()
                moveTo(13.88f, 13.87f)
                lineToRelative(-3.75f, -3.75f)
                lineToRelative(-6.86f, -6.86f)
                lineTo(2.0f, 4.53f)
                lineToRelative(6.86f, 6.86f)
                lineToRelative(-6.57f, 6.57f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(2.34f, 2.34f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(6.57f, -6.57f)
                lineTo(19.47f, 22.0f)
                lineToRelative(1.27f, -1.27f)
                lineToRelative(-6.86f, -6.86f)
                close()
            }
        }
        return _autoFixOff!!
    }

private var _autoFixOff: ImageVector? = null
