/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.BabyChangingStation: ImageVector
    get() {
        if (_babyChangingStation != null) {
            return _babyChangingStation!!
        }
        _babyChangingStation = materialIcon(name = "Filled.BabyChangingStation") {
            materialPath {
                moveTo(14.0f, 8.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-3.0f)
                lineTo(8.31f, 8.82f)
                lineTo(7.0f, 12.75f)
                verticalLineTo(22.0f)
                horizontalLineTo(3.0f)
                verticalLineTo(12.0f)
                lineToRelative(1.58f, -4.63f)
                curveTo(4.96f, 6.25f, 6.22f, 5.69f, 7.3f, 6.18f)
                lineToRelative(4.15f, 1.83f)
                lineTo(14.0f, 8.0f)
                close()
                moveTo(8.0f, 1.0f)
                curveTo(6.9f, 1.0f, 6.0f, 1.9f, 6.0f, 3.0f)
                reflectiveCurveToRelative(0.9f, 2.0f, 2.0f, 2.0f)
                reflectiveCurveToRelative(2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(9.1f, 1.0f, 8.0f, 1.0f)
                close()
                moveTo(9.0f, 19.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(9.0f)
                verticalLineTo(19.0f)
                close()
                moveTo(19.5f, 16.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                curveToRelative(0.0f, -0.83f, -0.67f, -1.5f, -1.5f, -1.5f)
                reflectiveCurveTo(18.0f, 13.67f, 18.0f, 14.5f)
                curveTo(18.0f, 15.33f, 18.67f, 16.0f, 19.5f, 16.0f)
                close()
                moveTo(13.0f, 12.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(12.0f)
                close()
            }
        }
        return _babyChangingStation!!
    }

private var _babyChangingStation: ImageVector? = null
