/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Diversity3: ImageVector
    get() {
        if (_diversity3 != null) {
            return _diversity3!!
        }
        _diversity3 = materialIcon(name = "Filled.Diversity3") {
            materialPath {
                moveTo(6.32f, 13.01f)
                curveToRelative(0.96f, 0.02f, 1.85f, 0.5f, 2.45f, 1.34f)
                curveTo(9.5f, 15.38f, 10.71f, 16.0f, 12.0f, 16.0f)
                curveToRelative(1.29f, 0.0f, 2.5f, -0.62f, 3.23f, -1.66f)
                curveToRelative(0.6f, -0.84f, 1.49f, -1.32f, 2.45f, -1.34f)
                curveTo(16.96f, 11.78f, 14.08f, 11.0f, 12.0f, 11.0f)
                curveTo(9.93f, 11.0f, 7.04f, 11.78f, 6.32f, 13.01f)
                close()
            }
            materialPath {
                moveTo(4.0f, 13.0f)
                lineTo(4.0f, 13.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveToRelative(-3.0f, 1.34f, -3.0f, 3.0f)
                curveTo(1.0f, 11.66f, 2.34f, 13.0f, 4.0f, 13.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 13.0f)
                lineTo(20.0f, 13.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveToRelative(-3.0f, 1.34f, -3.0f, 3.0f)
                curveTo(17.0f, 11.66f, 18.34f, 13.0f, 20.0f, 13.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 10.0f)
                curveToRelative(1.66f, 0.0f, 3.0f, -1.34f, 3.0f, -3.0f)
                curveToRelative(0.0f, -1.66f, -1.34f, -3.0f, -3.0f, -3.0f)
                reflectiveCurveTo(9.0f, 5.34f, 9.0f, 7.0f)
                curveTo(9.0f, 8.66f, 10.34f, 10.0f, 12.0f, 10.0f)
                close()
            }
            materialPath {
                moveTo(21.0f, 14.0f)
                horizontalLineToRelative(-3.27f)
                curveToRelative(-0.77f, 0.0f, -1.35f, 0.45f, -1.68f, 0.92f)
                curveTo(16.01f, 14.98f, 14.69f, 17.0f, 12.0f, 17.0f)
                curveToRelative(-1.43f, 0.0f, -3.03f, -0.64f, -4.05f, -2.08f)
                curveTo(7.56f, 14.37f, 6.95f, 14.0f, 6.27f, 14.0f)
                horizontalLineTo(3.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(-2.26f)
                curveToRelative(1.15f, 0.8f, 2.54f, 1.26f, 4.0f, 1.26f)
                reflectiveCurveToRelative(2.85f, -0.46f, 4.0f, -1.26f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(-4.0f)
                curveTo(23.0f, 14.9f, 22.1f, 14.0f, 21.0f, 14.0f)
                close()
            }
        }
        return _diversity3!!
    }

private var _diversity3: ImageVector? = null
