/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Hevc: ImageVector
    get() {
        if (_hevc != null) {
            return _hevc!!
        }
        _hevc = materialIcon(name = "Filled.Hevc") {
            materialPath {
                moveTo(5.5f, 11.0f)
                lineToRelative(-1.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(-1.5f, 0.0f)
                lineToRelative(0.0f, 6.0f)
                lineToRelative(1.5f, 0.0f)
                lineToRelative(0.0f, -2.5f)
                lineToRelative(1.0f, 0.0f)
                lineToRelative(0.0f, 2.5f)
                lineToRelative(1.5f, 0.0f)
                lineToRelative(0.0f, -6.0f)
                lineToRelative(-1.5f, 0.0f)
                close()
            }
            materialPath {
                moveTo(21.0f, 11.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(0.5f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(11.0f)
                horizontalLineTo(21.0f)
                close()
            }
            materialPath {
                moveTo(14.25f, 13.5f)
                lineToRelative(-0.75f, -4.5f)
                lineToRelative(-1.5f, 0.0f)
                lineToRelative(1.0f, 6.0f)
                lineToRelative(2.5f, 0.0f)
                lineToRelative(1.0f, -6.0f)
                lineToRelative(-1.5f, 0.0f)
                close()
            }
            materialPath {
                moveTo(8.0f, 9.0f)
                lineToRelative(0.0f, 6.0f)
                lineToRelative(3.5f, 0.0f)
                lineToRelative(0.0f, -1.5f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, -1.0f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, -1.5f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, -0.5f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, -1.5f)
                close()
            }
        }
        return _hevc!!
    }

private var _hevc: ImageVector? = null
