/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.MoneyOff: ImageVector
    get() {
        if (_moneyOff != null) {
            return _moneyOff!!
        }
        _moneyOff = materialIcon(name = "Filled.MoneyOff") {
            materialPath {
                moveTo(12.5f, 6.9f)
                curveToRelative(1.78f, 0.0f, 2.44f, 0.85f, 2.5f, 2.1f)
                horizontalLineToRelative(2.21f)
                curveToRelative(-0.07f, -1.72f, -1.12f, -3.3f, -3.21f, -3.81f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(2.16f)
                curveToRelative(-0.53f, 0.12f, -1.03f, 0.3f, -1.48f, 0.54f)
                lineToRelative(1.47f, 1.47f)
                curveToRelative(0.41f, -0.17f, 0.91f, -0.27f, 1.51f, -0.27f)
                close()
                moveTo(5.33f, 4.06f)
                lineTo(4.06f, 5.33f)
                lineTo(7.5f, 8.77f)
                curveToRelative(0.0f, 2.08f, 1.56f, 3.21f, 3.91f, 3.91f)
                lineToRelative(3.51f, 3.51f)
                curveToRelative(-0.34f, 0.48f, -1.05f, 0.91f, -2.42f, 0.91f)
                curveToRelative(-2.06f, 0.0f, -2.87f, -0.92f, -2.98f, -2.1f)
                horizontalLineToRelative(-2.2f)
                curveToRelative(0.12f, 2.19f, 1.76f, 3.42f, 3.68f, 3.83f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(-2.15f)
                curveToRelative(0.96f, -0.18f, 1.82f, -0.55f, 2.45f, -1.12f)
                lineToRelative(2.22f, 2.22f)
                lineToRelative(1.27f, -1.27f)
                lineTo(5.33f, 4.06f)
                close()
            }
        }
        return _moneyOff!!
    }

private var _moneyOff: ImageVector? = null
