/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.NoSim: ImageVector
    get() {
        if (_noSim != null) {
            return _noSim!!
        }
        _noSim = materialIcon(name = "Filled.NoSim") {
            materialPath {
                moveTo(18.99f, 5.0f)
                curveToRelative(0.0f, -1.1f, -0.89f, -2.0f, -1.99f, -2.0f)
                horizontalLineToRelative(-7.0f)
                lineTo(7.66f, 5.34f)
                lineTo(19.0f, 16.68f)
                lineTo(18.99f, 5.0f)
                close()
                moveTo(3.65f, 3.88f)
                lineTo(2.38f, 5.15f)
                lineTo(5.0f, 7.77f)
                verticalLineTo(19.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.01f)
                curveToRelative(0.35f, 0.0f, 0.67f, -0.1f, 0.96f, -0.26f)
                lineToRelative(1.88f, 1.88f)
                lineToRelative(1.27f, -1.27f)
                lineTo(3.65f, 3.88f)
                close()
            }
        }
        return _noSim!!
    }

private var _noSim: ImageVector? = null
